<?php
// Simple cleanup script for notification user IDs
require_once '../includes/config.php';

echo "<h3>Notification User ID Cleanup</h3>";

// Call the notification API cleanup function
$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, 'http://localhost/stylescore2025/htdocs/v2/api/notification_api.php');
curl_setopt($ch, CURLOPT_POST, 1);
curl_setopt($ch, CURLOPT_POSTFIELDS, 'action=cleanup_user_ids');
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type: application/x-www-form-urlencoded'));

$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

echo "<p><strong>HTTP Response Code:</strong> $httpCode</p>";
echo "<p><strong>Response:</strong></p>";
echo "<pre>" . htmlspecialchars($response) . "</pre>";

// Also show current notification_reads table content
try {
    $stmt = $pdo->prepare("SELECT * FROM notification_reads ORDER BY id DESC LIMIT 10");
    $stmt->execute();
    $reads = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h4>Current notification_reads table (last 10 entries):</h4>";
    echo "<table border='1'>";
    echo "<tr><th>ID</th><th>Notification ID</th><th>User ID</th><th>Read At</th></tr>";
    foreach ($reads as $read) {
        echo "<tr>";
        echo "<td>{$read['id']}</td>";
        echo "<td>{$read['notification_id']}</td>";
        echo "<td><strong>{$read['user_id']}</strong></td>";
        echo "<td>{$read['read_at']}</td>";
        echo "</tr>";
    }
    echo "</table>";
} catch (Exception $e) {
    echo "<p>Error reading notification_reads table: " . $e->getMessage() . "</p>";
}
?>
