<?php
require_once '../includes/db.php';

$stmt = $pdo->prepare('SELECT * FROM result_configurations WHERE event_id = ? ORDER BY created_at DESC');
$stmt->execute([3]);
$configs = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "Reports for Event 3:\n";
foreach($configs as $config) {
    echo "- ID: {$config['id']}, Name: {$config['name']}, Type: {$config['view_type']}, Heat: " . ($config['heat_number'] ?? 'all') . ", Status: {$config['status']}\n";
}

echo "\nNow checking the static API file being generated:\n";

// Check what the static API generates
try {
    $config_stmt = $pdo->prepare("SELECT id, name, view_type, heat_number, category, status, created_at FROM result_configurations WHERE event_id = ? AND status = 'active' ORDER BY created_at DESC");
    $config_stmt->execute([3]);
    $configs = $config_stmt->fetchAll(PDO::FETCH_ASSOC);
    $configs_payload = ['success'=>true,'configurations'=>$configs];
    
    echo "Static API configurations.json content:\n";
    echo json_encode($configs_payload, JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
}
?>
