<?php
include '../includes/auth.php';
include '../includes/db.php';

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Method not allowed']);
    exit;
}

$event_id = $_POST['event_id'] ?? null;
$bibs = $_POST['bibs'] ?? [];

if (!$event_id) {
    echo json_encode(['success' => false, 'message' => 'Event ID required']);
    exit;
}

try {
    $pdo->beginTransaction();
    
    $updated = 0;
    $errors = [];
    
    foreach ($bibs as $participant_id => $bib_number) {
        $bib_number = trim($bib_number);
        $bib_number = ($bib_number === '' || $bib_number === null) ? null : (int)$bib_number;
        
        // Update event_participants BIB number (this is the correct table for event-specific BIBs)
        $stmt = $pdo->prepare("UPDATE event_participants SET bib_number = ? WHERE participant_id = ? AND event_id = ?");
        $stmt->execute([$bib_number, $participant_id, $event_id]);
        
        // Also update participants table for backward compatibility
        $stmt2 = $pdo->prepare("UPDATE participants SET bib = ? WHERE id = ?");
        $stmt2->execute([$bib_number, $participant_id]);
        
        $updated++;
    }
    
    $pdo->commit();
    
    $_SESSION['success_message'] = "Successfully updated {$updated} BIB assignments";
    
    // Redirect back to BIB manager
    header("Location: bib_manager.php?event_id={$event_id}");
    exit;
    
} catch (Exception $e) {
    $pdo->rollBack();
    $_SESSION['error_message'] = "Error saving BIB assignments: " . $e->getMessage();
    header("Location: bib_manager.php?event_id={$event_id}");
    exit;
}
