<?php
include '../includes/db.php';

echo "<h2>Add Test Data to Event</h2>";

$event_id = $_GET['id'] ?? 1;

// First, show current data
$stmt = $pdo->prepare("SELECT id, name, sport_discipline, scoring_format, scoring_mode, location FROM events WHERE id = ?");
$stmt->execute([$event_id]);
$event = $stmt->fetch(PDO::FETCH_ASSOC);

if ($event) {
    echo "<h3>Current Event Data:</h3>";
    echo "<ul>";
    echo "<li>ID: {$event['id']}</li>";
    echo "<li>Name: " . htmlspecialchars($event['name']) . "</li>";
    echo "<li>Sport: " . htmlspecialchars($event['sport_discipline'] ?? 'NULL') . "</li>";
    echo "<li>Format: " . htmlspecialchars($event['scoring_format'] ?? 'NULL') . "</li>";
    echo "<li>Mode: " . htmlspecialchars($event['scoring_mode'] ?? 'NULL') . "</li>";
    echo "<li>Location: " . htmlspecialchars($event['location'] ?? 'NULL') . "</li>";
    echo "</ul>";
    
    // Add test data if fields are empty
    if (empty($event['sport_discipline']) || empty($event['location']) || empty($event['scoring_format'])) {
        echo "<h3>Adding Test Data...</h3>";
        
        $update_stmt = $pdo->prepare("
            UPDATE events 
            SET sport_discipline = 'skateboard',
                location = 'Test Skate Park Downtown',
                scoring_format = '1',
                scoring_mode = 'best'
            WHERE id = ?
        ");
        
        if ($update_stmt->execute([$event_id])) {
            echo "<p style='color: green;'>✅ Test data added successfully!</p>";
            echo "<ul>";
            echo "<li>Sport: skateboard</li>";
            echo "<li>Location: Test Skate Park Downtown</li>";
            echo "<li>Format: 1</li>";
            echo "<li>Mode: best</li>";
            echo "</ul>";
        } else {
            echo "<p style='color: red;'>❌ Failed to add test data</p>";
        }
    } else {
        echo "<p style='color: blue;'>Event already has data, no update needed.</p>";
    }
    
    echo "<p><a href='event_edit.php?id=$event_id' target='_blank'>Test Form with this Event</a></p>";
    echo "<p><a href='debug_event_data_clean.php?id=$event_id' target='_blank'>Debug Event Data</a></p>";
    
} else {
    echo "<p style='color: red;'>Event not found!</p>";
}
?>