<?php
/**
 * Migration: Add updated_at column to event_participants table
 * 
 * This migration adds a timestamp column that automatically updates
 * whenever a record in the event_participants table is modified.
 * 
 * Usage: php add_updated_at_migration.php
 */

require_once 'includes/db.php';

try {
    echo "Starting migration: Add updated_at to event_participants...\n";
    
    // Check if column already exists
    $check_stmt = $pdo->query("SHOW COLUMNS FROM event_participants LIKE 'updated_at'");
    if ($check_stmt->rowCount() > 0) {
        echo "✓ Column 'updated_at' already exists in event_participants table.\n";
        exit(0);
    }
    
    // Add updated_at column
    echo "Adding 'updated_at' column...\n";
    $pdo->exec("
        ALTER TABLE `event_participants` 
        ADD COLUMN `updated_at` TIMESTAMP NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP
        AFTER `participant_status`
    ");
    echo "✓ Column 'updated_at' added successfully.\n";
    
    // Set initial values for existing records
    echo "Setting initial timestamps for existing records...\n";
    $update_stmt = $pdo->exec("
        UPDATE `event_participants` 
        SET `updated_at` = CURRENT_TIMESTAMP 
        WHERE `updated_at` IS NULL
    ");
    echo "✓ Updated $update_stmt existing records.\n";
    
    echo "\n✅ Migration completed successfully!\n";
    echo "The 'updated_at' column will now automatically track when participant records are modified.\n";
    
} catch (PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
