<?php
/**
 * Migration: Add layout_x and layout_y columns to event_heat_settings table
 * This allows persisting flow editor node positions to the database
 */

require_once 'includes/db.php';

try {
    echo "Starting migration: Add layout positions to heat settings...\n";
    
    // Check if columns already exist
    $check = $pdo->query("SHOW COLUMNS FROM event_heat_settings LIKE 'layout_x'");
    if ($check->rowCount() > 0) {
        echo "Column layout_x already exists. Skipping migration.\n";
        exit(0);
    }
    
    // Add layout_x column
    $pdo->exec("ALTER TABLE `event_heat_settings` 
                ADD COLUMN `layout_x` INT DEFAULT NULL 
                COMMENT 'Flow editor node X position' 
                AFTER `flow_position_range`");
    echo "✓ Added column: layout_x\n";
    
    // Add layout_y column
    $pdo->exec("ALTER TABLE `event_heat_settings` 
                ADD COLUMN `layout_y` INT DEFAULT NULL 
                COMMENT 'Flow editor node Y position' 
                AFTER `layout_x`");
    echo "✓ Added column: layout_y\n";
    
    echo "\n✓ Migration completed successfully!\n";
    echo "Flow editor node positions will now persist in the database.\n";
    
} catch (PDOException $e) {
    echo "✗ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
