<!DOCTYPE html>
<html>
<head>
    <title>Database Migration: Add Hue Offset</title>
    <style>
        body { font-family: Arial, sans-serif; padding: 20px; background: #f5f5f5; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); }
        .success { color: #28a745; }
        .error { color: #dc3545; }
        .info { color: #007bff; }
        pre { background: #f8f9fa; padding: 15px; border-radius: 4px; overflow-x: auto; }
    </style>
</head>
<body>
    <div class="container">
        <h1>Database Migration: Add Hue Offset to Heat Settings</h1>
        
        <?php
        require_once 'includes/db.php';
        
        try {
            echo "<p class='info'>Starting migration...</p>";
            
            // Check if column already exists
            $check = $pdo->query("SHOW COLUMNS FROM event_heat_settings LIKE 'hue_offsets'");
            if ($check->rowCount() > 0) {
                echo "<p class='info'>✓ Column hue_offsets already exists. Skipping migration.</p>";
                echo "<p class='success'><strong>Migration completed (no changes needed).</strong></p>";
                exit(0);
            }
            
            // Add hue_offsets column
            $pdo->exec("ALTER TABLE `event_heat_settings` 
                        ADD COLUMN `hue_offsets` TEXT DEFAULT NULL 
                        COMMENT 'Flow connection color hue offsets as JSON object {source_heat: hue_offset}' 
                        AFTER `layout_y`");
            echo "<p class='success'>✓ Added column: hue_offsets</p>";
            
            echo "<hr>";
            echo "<p class='success'><strong>✓ Migration completed successfully!</strong></p>";
            echo "<p class='info'>Flow connection colors can now be customized with hue offset.</p>";
            echo "<p class='info'>This helps distinguish multiple connections from the same source heat.</p>";
            
            // Show the updated structure
            echo "<h3>Updated Table Structure:</h3>";
            echo "<pre>";
            $columns = $pdo->query("SHOW COLUMNS FROM event_heat_settings")->fetchAll(PDO::FETCH_ASSOC);
            foreach ($columns as $col) {
                if (in_array($col['Field'], ['hue_offsets', 'layout_x', 'layout_y', 'flow_position_range', 'flow_participants_per_category', 'flow_type', 'flow_source_heat'])) {
                    $comment = isset($col['Comment']) && !empty($col['Comment']) ? " - " . $col['Comment'] : "";
                    echo $col['Field'] . " - " . $col['Type'] . $comment . "\n";
                }
            }
            echo "</pre>";
            
        } catch (PDOException $e) {
            echo "<p class='error'>✗ Migration failed: " . htmlspecialchars($e->getMessage()) . "</p>";
            echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
        }
        ?>
        
        <hr>
        <p><a href="admin/admin_heat_config.php">← Back to Heat Configuration</a></p>
    </div>
</body>
</html>
