<?php
/**
 * Migration: Add drop_rule column to event_heat_settings table
 * 
 * This migration adds support for heat-specific drop_rule overrides.
 * When NULL, the heat will use the event's default drop_rule from scoring_format_judges.
 * When set to a value ('none', 'lowest', 'highest', 'highest_and_lowest'), 
 * it overrides the event default for that specific heat.
 */

require_once 'includes/db.php';

echo "Adding drop_rule column to event_heat_settings table...\n";

try {
    // Check if column already exists
    $check = $pdo->query("SHOW COLUMNS FROM event_heat_settings LIKE 'drop_rule'");
    
    if ($check->rowCount() > 0) {
        echo "Column 'drop_rule' already exists in event_heat_settings table.\n";
        exit(0);
    }
    
    // Add the column
    $pdo->exec("
        ALTER TABLE `event_heat_settings` 
        ADD COLUMN `drop_rule` VARCHAR(100) DEFAULT NULL 
        COMMENT 'Override drop rule for judge scores (none, lowest, highest, highest_and_lowest)' 
        AFTER `precision_decimal`
    ");
    
    echo "✓ Successfully added drop_rule column to event_heat_settings table.\n";
    echo "  - Column allows NULL (uses event default) or specific drop rule values\n";
    echo "  - Valid values: NULL (use event default), 'none', 'lowest', 'highest', 'highest_and_lowest'\n";
    
} catch (PDOException $e) {
    echo "✗ Error adding drop_rule column: " . $e->getMessage() . "\n";
    exit(1);
}

echo "\nMigration completed successfully!\n";
?>
