<?php
/**
 * Migration Script: Add diversity_rules_enabled column to event_heat_settings
 * 
 * This script adds the ability to enable/disable diversity rules per heat
 */

require_once 'includes/db.php';

try {
    echo "Starting migration: Add diversity_rules_enabled column\n";
    echo "================================================\n\n";
    
    // Check if column already exists
    $checkStmt = $pdo->query("SHOW COLUMNS FROM event_heat_settings LIKE 'diversity_rules_enabled'");
    $columnExists = $checkStmt->fetch();
    
    if ($columnExists) {
        echo "✓ Column 'diversity_rules_enabled' already exists in event_heat_settings table.\n";
        echo "  No migration needed.\n\n";
    } else {
        echo "Adding 'diversity_rules_enabled' column to event_heat_settings table...\n";
        
        // Add the column
        $pdo->exec("
            ALTER TABLE `event_heat_settings` 
            ADD COLUMN `diversity_rules_enabled` TINYINT(1) NOT NULL DEFAULT 1 
            COMMENT 'Whether to apply diversity rules from scoring format (1=apply, 0=ignore)' 
            AFTER `flow_position_range`
        ");
        
        echo "✓ Column added successfully!\n\n";
        
        // Update existing records to have diversity rules enabled by default
        echo "Setting default value for existing records...\n";
        $updateStmt = $pdo->exec("UPDATE `event_heat_settings` SET `diversity_rules_enabled` = 1");
        echo "✓ Updated {$updateStmt} existing records.\n\n";
    }
    
    echo "================================================\n";
    echo "Migration completed successfully!\n\n";
    
    echo "You can now use the diversity rules setting in Heat Configuration:\n";
    echo "- Navigate to Admin > Heat Configuration\n";
    echo "- Edit any heat in the 'Participants & Flow' tab\n";
    echo "- Toggle 'Apply Diversity Rules' to enable/disable diversity validation\n\n";
    
} catch (PDOException $e) {
    echo "✗ Error during migration: " . $e->getMessage() . "\n";
    echo "  Please check your database connection and try again.\n\n";
    exit(1);
}
