-- Add diversity_rules_enabled column to event_heat_settings table
-- This column controls whether diversity rules from the scoring format should be applied to a specific heat

ALTER TABLE `event_heat_settings` 
ADD COLUMN `diversity_rules_enabled` TINYINT(1) NOT NULL DEFAULT 1 
COMMENT 'Whether to apply diversity rules from scoring format (1=apply, 0=ignore)' 
AFTER `flow_position_range`;

-- Update existing records to have diversity rules enabled by default
UPDATE `event_heat_settings` SET `diversity_rules_enabled` = 1 WHERE `diversity_rules_enabled` IS NULL;
