<?php
/**
 * Migration: Add created_by column to users table
 * Tracks which user created each user account
 */

require_once 'includes/db.php';

try {
    echo "Adding 'created_by' column to users table...\n";
    
    // Check if column already exists
    $check = $pdo->query("SHOW COLUMNS FROM users LIKE 'created_by'");
    if ($check->rowCount() > 0) {
        echo "✓ Column 'created_by' already exists.\n";
    } else {
        // Add created_by column
        $pdo->exec("
            ALTER TABLE users 
            ADD COLUMN created_by INT NULL AFTER role,
            ADD CONSTRAINT fk_users_created_by 
            FOREIGN KEY (created_by) REFERENCES users(id) 
            ON DELETE SET NULL
        ");
        echo "✓ Column 'created_by' added successfully.\n";
    }
    
    // Add index for better performance
    $pdo->exec("CREATE INDEX IF NOT EXISTS idx_users_created_by ON users(created_by)");
    echo "✓ Index created on 'created_by' column.\n";
    
    echo "\n=== Migration completed successfully ===\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    exit(1);
}
?>