<?php
/**
 * Migration: Add assigned_events column to users table
 *
 * Usage: php add_assigned_events_migration.php
 */

require_once 'includes/db.php';

try {
    echo "Starting migration: Add assigned_events to users...\n";

    // Check if column already exists
    $check_stmt = $pdo->query("SHOW COLUMNS FROM `users` LIKE 'assigned_events'");
    if ($check_stmt->rowCount() > 0) {
        echo "✓ Column 'assigned_events' already exists in users table.\n";
        exit(0);
    }

    // Add assigned_events column
    echo "Adding 'assigned_events' column...\n";
    $pdo->exec("
        ALTER TABLE `users`
        ADD COLUMN `assigned_events` TEXT NULL DEFAULT NULL
        AFTER `role`
    ");
    echo "✓ Column 'assigned_events' added successfully.\n";

    echo "\n✅ Migration completed successfully!\n";
    echo "The 'assigned_events' column can hold a comma-separated list of event IDs or a small JSON array.\n";

} catch (PDOException $e) {
    echo "❌ Migration failed: " . $e->getMessage() . "\n";
    exit(1);
}
