# SFTP Setup Guide for StyleScore Publish Servers

## Overview
The StyleScore publish servers now use **SFTP (SSH File Transfer Protocol)** instead of FTP for secure file transfers. This requires the PHP SSH2 extension to be installed and enabled.

## Why SFTP?
- **Secure**: All data is encrypted during transfer
- **Single Port**: Uses only port 22 (SSH)
- **Better Compatibility**: Works with modern hosting providers
- **Key-based Authentication**: Supports SSH keys (future enhancement)

---

## Installation Instructions

### Windows (XAMPP/WAMP)

#### Option 1: Using PECL (Recommended)
1. Download the SSH2 DLL from PECL:
   - Go to: https://pecl.php.net/package/ssh2
   - Download the appropriate version for your PHP version
   - For PHP 8.x: `php_ssh2-1.4.1-8.x-nts-vs16-x64.zip`

2. Extract the ZIP file and copy `php_ssh2.dll` to:
   ```
   C:\xampp\php\ext\
   ```

3. Edit `php.ini` (located in `C:\xampp\php\php.ini`):
   ```ini
   extension=ssh2
   ```

4. Restart Apache

#### Option 2: Manual Installation
1. Download libssh2 library:
   - https://github.com/libssh2/libssh2/releases
   - Download `libssh2.dll`
   
2. Copy `libssh2.dll` to:
   ```
   C:\xampp\php\
   C:\xampp\apache\bin\
   ```

3. Follow steps 1-4 from Option 1 above

### Linux (Ubuntu/Debian)

```bash
# Install SSH2 extension
sudo apt-get update
sudo apt-get install php-ssh2

# Or compile from source
sudo apt-get install libssh2-1-dev php-dev php-pear
sudo pecl install ssh2

# Enable the extension
echo "extension=ssh2.so" | sudo tee /etc/php/8.x/mods-available/ssh2.ini
sudo phpenmod ssh2

# Restart web server
sudo systemctl restart apache2
# or for nginx
sudo systemctl restart php8.x-fpm
```

### Linux (CentOS/RHEL)

```bash
# Install EPEL repository
sudo yum install epel-release

# Install SSH2
sudo yum install php-ssh2

# Or via PECL
sudo yum install libssh2-devel php-devel php-pear
sudo pecl install ssh2

# Enable extension
echo "extension=ssh2.so" > /etc/php.d/ssh2.ini

# Restart web server
sudo systemctl restart httpd
```

### macOS (with Homebrew)

```bash
# Install libssh2
brew install libssh2

# Install SSH2 extension via PECL
pecl install ssh2

# Add to php.ini
echo "extension=ssh2.so" >> $(php --ini | grep "Loaded Configuration" | sed -e "s|.*:\s*||")

# Restart web server
brew services restart httpd
# or
brew services restart php
```

---

## Verification

### Check if SSH2 is Installed

Create a file `check_ssh2.php` in your web root:

```php
<?php
if (function_exists('ssh2_connect')) {
    echo "✅ SSH2 extension is INSTALLED and WORKING!";
    echo "<br>Version: " . phpversion('ssh2');
} else {
    echo "❌ SSH2 extension is NOT installed";
    echo "<br>Please follow the installation guide.";
}

phpinfo(INFO_MODULES);
```

Or check via command line:
```bash
php -m | grep ssh2
```

If installed correctly, you should see `ssh2` in the output.

---

## Configuration

### SFTP Server Setup

1. **Default Port**: 22 (SSH default)
2. **Username**: Your SFTP username
3. **Password**: Your SFTP password
4. **Remote Path**: Target directory on the server (e.g., `/home/user/public_html/`)

### Testing Connection

1. Go to: **Admin → Publish Servers**
2. Click **"Add Publish Server"**
3. Fill in your SFTP details
4. Click **"Test Connection"**
5. You should see: ✅ "SFTP connection successful"

---

## Troubleshooting

### Error: "SSH2 extension is not installed"
**Solution**: Follow the installation steps above for your operating system.

### Error: "Could not connect to SFTP server"
**Possible causes**:
- Wrong hostname or port
- Firewall blocking port 22
- Server not accepting connections

**Solutions**:
- Verify hostname is correct
- Try connecting via command line: `ssh username@hostname`
- Check firewall rules
- Contact your hosting provider

### Error: "SFTP authentication failed"
**Possible causes**:
- Wrong username or password
- Account locked or disabled

**Solutions**:
- Verify credentials
- Try logging in via SSH client (PuTTY, Terminal)
- Reset password if needed
- Check with hosting provider

### Error: "Could not initialize SFTP subsystem"
**Possible causes**:
- SFTP subsystem disabled on server
- SSH2 extension not properly configured

**Solutions**:
- Contact hosting provider to enable SFTP
- Reinstall SSH2 extension
- Check PHP error logs for details

### Connection works but files don't upload
**Possible causes**:
- Insufficient permissions on remote directory
- Disk quota exceeded
- SELinux blocking writes (Linux)

**Solutions**:
- Check directory permissions (should be writable)
- Verify disk space available
- Check SELinux settings: `sudo setenforce 0` (temporarily)

---

## Migration from FTP

### If you have existing FTP servers configured:

1. **Update server settings**:
   - Change port from 21 to 22
   - Verify hostname is correct for SFTP
   - Test connection

2. **Host differences**:
   - FTP: `ftp.example.com` (port 21)
   - SFTP: `sftp.example.com` or same hostname (port 22)

3. **Path differences**:
   - FTP paths may differ from SFTP paths
   - Check with your hosting provider for correct paths

---

## Security Best Practices

1. **Use Strong Passwords**: Minimum 12 characters with mixed case, numbers, symbols
2. **Restrict Access**: Only allow specific IP addresses if possible
3. **Regular Updates**: Keep PHP and SSH2 extension updated
4. **Monitor Logs**: Check publish logs regularly for failures
5. **Backup Credentials**: Store credentials securely

---

## Future Enhancements

Planned features for SFTP implementation:

- [ ] SSH Key-based authentication (no password needed)
- [ ] Connection pooling for faster uploads
- [ ] Resume interrupted transfers
- [ ] Bandwidth throttling
- [ ] Upload progress tracking

---

## Support

### Check Installation
```bash
# Command line check
php -r "if (function_exists('ssh2_connect')) echo 'SSH2 OK'; else echo 'SSH2 Missing';"
```

### View PHP Configuration
```bash
php -i | grep -i ssh2
```

### Test SFTP Connection (Command Line)
```bash
sftp username@hostname
# Enter password when prompted
# Type 'quit' to exit
```

---

## Additional Resources

- **PHP SSH2 Documentation**: https://www.php.net/manual/en/book.ssh2.php
- **PECL SSH2 Package**: https://pecl.php.net/package/ssh2
- **libssh2 Library**: https://www.libssh2.org/
- **SFTP RFC**: https://datatracker.ietf.org/doc/html/draft-ietf-secsh-filexfer

---

## Contact

For technical support or questions:
- Check the StyleScore documentation
- Review PHP error logs: `C:\xampp\php\logs\php_error_log` (Windows) or `/var/log/php/error.log` (Linux)
- Contact your hosting provider for server-specific issues

---

**Last Updated**: November 16, 2025
**Version**: 2.0 (SFTP Implementation)
