# Event Metadata Integration in Results Styling

## Overview
Event metadata is now automatically loaded and displayed in the results styling system, formatted similarly to the `#previewContent` display from `event_metadata.php`.

## Changes Made

### 1. **results_styling.php** - Main Integration
- **Line 3**: Added `include '../includes/event_metadata_helpers.php';` to load metadata functions
- **Lines 295-365**: Added metadata loading and formatting logic in `getStyledHeaderFooter()` function
  - Loads event metadata using `getEventMetadata($pdo, $event_id)`
  - Groups fields using `getFieldsByGroup($event_metadata)`
  - Filters out empty fields
  - Formats metadata in 2-column layout (similar to preview)
  - Includes judges list if available
  - Generates HTML with inline styles for PDF compatibility

### 2. **Metadata Display Features**
The metadata is displayed in the header section with:
- **Grouped Layout**: Metadata fields organized by group (Jury Information, Technical Data, etc.)
- **Two-column Design**: Groups displayed side-by-side for space efficiency
- **Conditional Display**: Only shows groups and fields with actual values
- **Judges Section**: Separate display for judges with license badges
- **Styled Output**: Uses primary/secondary colors from styling configuration
- **PDF-Ready**: All styles are inline for PDF generation compatibility

### 3. **Data Structure**
The `getStyledHeaderFooter()` function now returns:
```php
[
    'header_html' => string,      // Complete header HTML with metadata
    'footer_html' => string,      // Footer HTML
    'custom_css' => string,       // Custom CSS from styling
    'styling' => array,           // Full styling configuration
    'metadata_html' => string,    // Formatted metadata HTML (standalone)
    'metadata_groups' => array,   // Grouped metadata fields
    'event_metadata' => array     // Raw event metadata
]
```

### 4. **HTML Output Example**
When metadata is present, it appears in the header like:

```html
<div style="margin-top: 10px; font-size: 0.9em; line-height: 1.4;">
    <div style="display: inline-block; vertical-align: top; width: 48%; margin-right: 2%;">
        <h6 style="color: #0d6efd; border-bottom: 1px solid;">
            <i class="fas fa-folder"></i>Jury Information
        </h6>
        <dl>
            <dt>Technical Delegate FIS:</dt><dd>John Smith</dd>
            <dt>Head Judge:</dt><dd>Jane Doe</dd>
        </dl>
    </div>
    
    <div style="display: inline-block; vertical-align: top; width: 48%;">
        <h6 style="color: #ffc107; border-bottom: 1px solid;">
            <i class="fas fa-users"></i>Judges
        </h6>
        <ol>
            <li>Judge 1 <span style="background: #6c757d;">License #123</span></li>
            <li>Judge 2 <span style="background: #6c757d;">License #456</span></li>
        </ol>
    </div>
</div>
```

## Usage

### In API Calls (summary_table_api.php, start_list_api.php)
```php
$styling_data = getStyledHeaderFooter($pdo, $event_id, $config_id);

// Metadata is automatically included in header_html
echo $styling_data['header_html'];

// Or access standalone metadata
echo $styling_data['metadata_html'];
```

### Metadata Display Control
- Metadata displays automatically if fields have values
- Empty fields/groups are filtered out
- Display controlled by `show_event_info` styling option (same as event details)

## Testing

### Test Script: `test_metadata_styling.php`
A dedicated test page to verify metadata integration:
- URL: `/v2/admin/test_metadata_styling.php?event_id=X`
- Shows formatted metadata HTML
- Displays metadata groups and raw data
- Previews full header with embedded metadata
- Links to edit metadata and styling

### Manual Testing Steps
1. Go to **Event Metadata Manager** (`event_metadata.php`)
2. Fill in metadata fields (Jury Information, Technical Data, etc.)
3. Add judges if needed
4. Save metadata
5. Go to **Results Styling** (`results_styling.php`) and save styling
6. Generate results via API (`summary_table_api.php` or `start_list_api.php`)
7. Verify metadata appears in PDF/HTML output

## Styling Options

### Color Customization
- **Group Headers**: Use `primary_color` from styling configuration
- **Judges Section**: Uses warning color (`#ffc107`) to differentiate
- **Text Color**: Uses `secondary_color` for metadata text

### Layout Control
The metadata HTML is inserted in the header section at line 634:
```php
<?php if (!empty($metadata_html)): ?>
    <div style="margin-top: 10px; font-size: 0.9em; line-height: 1.4;">
        <?= $metadata_html ?>
    </div>
<?php endif; ?>
```

You can adjust:
- `font-size`: Change `0.9em` to make text larger/smaller
- `margin-top`: Adjust spacing from event info line
- `line-height`: Control vertical spacing

## Benefits

1. **Automatic Integration**: No manual copying of metadata to headers
2. **Consistent Formatting**: Matches preview style from metadata editor
3. **Dynamic Updates**: Changes in metadata automatically reflect in outputs
4. **PDF Compatible**: All styles inline for reliable PDF rendering
5. **Flexible Display**: Only shows populated fields/groups
6. **Professional Output**: Clean 2-column layout with proper styling

## Future Enhancements

Potential improvements:
- Add option to show/hide metadata in styling settings
- Allow custom positioning (header vs footer)
- Support for custom metadata templates
- Per-configuration metadata overrides
- Metadata visibility toggles per field/group

## Related Files
- `admin/results_styling.php` - Main styling system with metadata integration
- `admin/event_metadata.php` - Metadata editor interface
- `includes/event_metadata_helpers.php` - Metadata helper functions
- `api/summary_table_api.php` - API using styled headers with metadata
- `api/start_list_api.php` - API using styled headers with metadata
- `admin/test_metadata_styling.php` - Testing and verification tool
