# Manual SSH2 Installation Guide for PHP 8.2 (ZTS x64)

## Your Configuration:
- PHP Version: 8.2.4
- Thread Safety: ZTS (Thread Safe)
- Architecture: x64
- PHP Directory: C:\xampp\php
- Extensions Directory: C:\xampp\php\ext

## Step-by-Step Installation:

### Option 1: Download Pre-compiled DLLs (Recommended)

1. **Download SSH2 Extension:**
   - Visit: https://pecl.php.net/package/ssh2
   - Click on "DLL" link next to the latest version
   - OR direct link: https://windows.php.net/downloads/pecl/releases/ssh2/
   - Download the file matching: **php_ssh2-xxx-8.2-ts-vs16-x64.zip**
   - Note: "ts" = Thread Safe, "vs16" = Visual Studio 2019, "x64" = 64-bit

2. **Extract SSH2:**
   - Extract the ZIP file
   - Find `php_ssh2.dll`
   - Copy it to: `C:\xampp\php\ext\`

3. **Download libssh2 Dependency:**
   - Visit: https://windows.php.net/downloads/pecl/deps/
   - Download: `libssh2-xxx-vs16-x64.zip` (latest version)
   
4. **Extract libssh2:**
   - Extract the ZIP file
   - Find `libssh2.dll`
   - Copy it to TWO locations:
     * `C:\xampp\php\`
     * `C:\xampp\apache\bin\`

5. **Edit php.ini:**
   - Open: `C:\xampp\php\php.ini` in a text editor
   - Find the section with other extensions (search for "extension=")
   - Add this line:
     ```
     extension=ssh2
     ```
   - Save the file

6. **Restart Apache:**
   - Open XAMPP Control Panel
   - Click "Stop" for Apache
   - Wait a few seconds
   - Click "Start" for Apache

7. **Verify Installation:**
   - Visit: http://localhost/v2/admin/check_ssh2.php
   - You should see a green checkmark!

---

### Option 2: Alternative Download Sources

If PECL downloads don't work, try these mirrors:

**GitHub Releases:**
- https://github.com/sean-der/pecl-ssh2-windows/releases
- Download the appropriate version for PHP 8.2 TS x64

**SourceForge:**
- Search for "php ssh2 windows" on SourceForge

---

### Option 3: Quick Manual Download (Direct Links)

I've prepared a simple batch script to help. Run this in PowerShell:

```powershell
# Create directories
$extDir = "C:\xampp\php\ext"
$phpDir = "C:\xampp\php"
$apacheDir = "C:\xampp\apache\bin"

# Open browser to download pages
Start-Process "https://pecl.php.net/package/ssh2"
Start-Process "https://windows.php.net/downloads/pecl/deps/"

# Instructions
Write-Host "1. Download php_ssh2-xxx-8.2-ts-vs16-x64.zip from first page"
Write-Host "2. Download libssh2-xxx-vs16-x64.zip from second page"
Write-Host "3. Extract php_ssh2.dll to: $extDir"
Write-Host "4. Extract libssh2.dll to: $phpDir AND $apacheDir"
Write-Host "5. Add 'extension=ssh2' to C:\xampp\php\php.ini"
Write-Host "6. Restart Apache"
```

---

### Troubleshooting:

**After installation, SSH2 still not working?**

1. **Check php.ini location:**
   ```cmd
   C:\xampp\php\php.exe --ini
   ```
   Make sure you edited the correct php.ini file!

2. **Check if DLL is loaded:**
   ```cmd
   C:\xampp\php\php.exe -m | findstr ssh2
   ```
   Should show "ssh2" in the output

3. **Check Apache error log:**
   - Open: `C:\xampp\apache\logs\error.log`
   - Look for SSH2 related errors

4. **Missing DLL errors:**
   - Make sure `libssh2.dll` is in BOTH locations:
     * `C:\xampp\php\libssh2.dll`
     * `C:\xampp\apache\bin\libssh2.dll`

5. **Visual C++ Runtime:**
   - Download and install: https://aka.ms/vs/17/release/vc_redist.x64.exe
   - This provides required runtime libraries

---

### Verification Commands:

After installation, run these to verify:

```cmd
REM Check if extension is loaded
C:\xampp\php\php.exe -m | findstr ssh2

REM Check SSH2 version
C:\xampp\php\php.exe -r "if (function_exists('ssh2_connect')) echo 'SSH2 OK - Version: ' . phpversion('ssh2'); else echo 'SSH2 NOT FOUND';"

REM List all extensions
C:\xampp\php\php.exe -m
```

---

### Quick Links:

- **PECL SSH2**: https://pecl.php.net/package/ssh2
- **Windows PHP Downloads**: https://windows.php.net/downloads/pecl/
- **Visual C++ Redistributable**: https://aka.ms/vs/17/release/vc_redist.x64.exe
- **XAMPP Forums**: https://community.apachefriends.org/

---

### Need Help?

1. Check the web-based checker: http://localhost/v2/admin/check_ssh2.php
2. Read the full guide: `SFTP_SETUP_GUIDE.md`
3. Check Apache error logs for specific errors

---

**Note**: If you absolutely cannot get SSH2 working, there's an alternative approach using phpseclib (pure PHP SFTP library). Let me know if you need that instead.
