# HTML Table Publishing for Public Server

## Overview

This document describes the new HTML table publishing functionality that generates standalone HTML files for summary tables that can be uploaded to the public server.

## What Changed

### New Approach
Instead of only generating JSON data files, the system now **also generates complete HTML table files** that can be directly accessed on the public server without requiring JavaScript to render.

### Files Modified

1. **`admin/publish_generators.php`**
   - Added `generateSummaryTableHTMLs()` function
   - Added `buildSummaryTableHTMLUrl()` function
   - Integrated HTML generation into `generateStaticHTMLDashboard()`

2. **`admin/test_html_table_generation.php`** (new)
   - Test script to verify HTML table generation

## How It Works

### 1. Configuration-Based Generation

For each **public** summary table configuration in the database (`result_configurations` table), the system:

1. Reads the configuration settings (columns, filters, sorting, etc.)
2. Builds an API URL with `format=html&styling=partial`
3. Calls the `summary_table_api.php` endpoint to generate the HTML
4. Saves the HTML to a file named `summary_table_[config_id].html`

### 2. Publishing Flow

```
Event Publishing
    ↓
Generate Static Dashboard
    ↓
Generate API JSON files (existing)
    ↓
Generate HTML Tables (NEW) ← Added here
    ↓
Copy Photos
    ↓
Copy Assets
    ↓
Upload to FTP/SFTP
```

### 3. File Structure

After publishing, the public server will have:

```
public-server/
├── index.html                     # Main dashboard
├── api/
│   ├── events_overview.json       # JSON data
│   ├── summary_table_74.json      # JSON data
│   └── summary_table_89.json      # JSON data
├── tables/                        # NEW DIRECTORY
│   ├── summary_table_74.html      # Standalone HTML table
│   ├── summary_table_89.html      # Standalone HTML table
│   └── summary_table_90.html      # Standalone HTML table
└── photos/
    └── ...
```

## Usage

### Accessing HTML Tables

Once published, HTML tables can be accessed directly via URL:

```
https://your-public-server.com/tables/summary_table_89.html
https://your-public-server.com/tables/summary_table_74.html
```

These are **complete HTML documents** that include:
- Full HTML structure (DOCTYPE, head, body)
- Inline CSS styles from result styling configuration
- Table data with proper formatting
- Header and footer from result styling (if configured)

### Testing Locally

To test HTML table generation:

```bash
# Open the test page in browser
http://localhost/v2/admin/test_html_table_generation.php
```

Or run via PHP CLI:
```powershell
C:\xampp\php\php.exe c:\stylescore2025\htdocs\v2\admin\test_html_table_generation.php
```

### Publishing to Server

Use the existing publish interface:

1. Go to **Admin → Publish Servers**
2. Select your event
3. Choose publish options
4. Click **Publish**

The HTML tables will automatically be included in the upload.

## API Endpoint Used

The HTML generation uses the existing `summary_table_api.php` endpoint with these key parameters:

```
format=html              # Returns HTML instead of JSON
styling=partial          # Includes minimal styling
```

**Example URL:**
```
http://localhost/v2/api/summary_table_api.php?
  event_id=3&
  format=html&
  styling=partial&
  heat_run_filter={"1":[1,2,3,4,5],"2":[1,2,3,4,5]}&
  show_rank=true&
  show_bib=true&
  show_participant=true&
  ...
```

## Configuration Requirements

### Result Configurations

HTML tables are generated for configurations that meet these criteria:

- **`view_type`**: `summary_table`
- **`status`**: `public`
- **`event_id`**: Matches the event being published

### Settings Supported

All standard summary table settings are supported:

- ✅ Heat/run filtering
- ✅ Column visibility (rank, BIB, name, category, club, etc.)
- ✅ Column renaming
- ✅ Sorting (by any column, asc/desc)
- ✅ Gender filtering
- ✅ Category filtering
- ✅ Heat direction (row/column layout)
- ✅ Show heat best, heat average, overall scores
- ✅ Result styling (header/footer)

## Benefits

### 1. Direct Access
HTML tables can be embedded in external websites using iframes:
```html
<iframe src="https://your-server.com/tables/summary_table_89.html" 
        width="100%" 
        height="600"></iframe>
```

### 2. SEO Friendly
Search engines can index the table content directly.

### 3. No JavaScript Required
Tables work even if JavaScript is disabled in the browser.

### 4. Fast Loading
Pre-rendered HTML loads instantly without client-side rendering.

### 5. Print Friendly
Tables can be printed directly from the browser.

## Function Reference

### `generateSummaryTableHTMLs($event_id, $temp_dir, $pdo)`

Generates HTML table files for all public summary table configurations.

**Parameters:**
- `$event_id` - Event ID to generate tables for
- `$temp_dir` - Temporary directory to save files
- `$pdo` - Database connection

**Returns:**
Array of file mappings: `[['local' => '...', 'remote' => 'tables/...'], ...]`

### `buildSummaryTableHTMLUrl($config)`

Builds the API URL to generate HTML for a specific configuration.

**Parameters:**
- `$config` - Configuration array from `result_configurations` table

**Returns:**
String URL to call the summary table API with HTML format

## Troubleshooting

### No HTML files generated

**Check:**
1. Are there public summary table configurations?
   ```sql
   SELECT * FROM result_configurations 
   WHERE event_id = 3 
   AND view_type = 'summary_table' 
   AND status = 'public';
   ```

2. Is the API accessible?
   - Test the API URL directly in browser
   - Check for PHP errors in logs

### Empty or malformed HTML

**Check:**
1. Event has participant data
2. Scores exist for the event
3. Configuration settings are valid JSON

### Files not uploaded to FTP

**Check:**
1. FTP credentials are correct
2. Remote directory has write permissions
3. Check publish logs for upload errors

## Example Output

The generated HTML includes:

```html
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Summary Table - Event 3</title>
    <style>
        /* Badge colors and table styling */
    </style>
</head>
<body>
    <!-- Header from result styling -->
    <div class="results-header">...</div>
    
    <!-- Summary table -->
    <div class="summary-table-section">
        <table class="table table-striped">
            <thead>
                <tr>
                    <th>Rank</th>
                    <th>BIB</th>
                    <th>Name</th>
                    <th>Category</th>
                    <th>Best.Rr</th>
                    ...
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>42</td>
                    <td>John Doe</td>
                    <td>Male Senior</td>
                    <td>95.50</td>
                    ...
                </tr>
                ...
            </tbody>
        </table>
    </div>
    
    <!-- Footer from result styling -->
    <div class="results-footer">...</div>
</body>
</html>
```

## Future Enhancements

Possible improvements:

1. **Custom CSS per table** - Allow different styling for each configuration
2. **Auto-refresh meta tag** - Add auto-refresh for live events
3. **Print CSS** - Optimize styling for printing
4. **Dark mode** - Support dark theme variant
5. **Export button** - Add download/print buttons to HTML tables

## Notes

- HTML generation adds minimal overhead to publishing process
- Files are generated from the same API endpoint as JSON tables
- Configuration changes require republishing to update HTML
- HTML files include inline styles for portability
