# Drawing Board Background Templates System

## Overview
Judges can now create reusable background templates for their drawings, allowing them to use the same slope/rail/feature diagram across multiple runs and heats.

## Features Implemented

### 1. **Auto-Load Last Used Background**
- When opening the drawing board, the system automatically:
  1. Checks if a drawing already exists for this participant/heat/run
  2. If yes: Loads both background and foreground layers + notes
  3. If no: Loads the last used background from any previous drawing
  4. If no previous background: Starts with empty canvas

### 2. **Save Background as Template**
- Judges can save the current background layer as a named template
- Button: "Save BG" in toolbar (💾 icon)
- Prompts for template name (e.g., "Slopestyle Course A")
- Template is saved to database with status='template'
- Stored in `/drawings/backgrounds/` directory

### 3. **Load Template**
- Judges can browse and load saved templates
- Button: "Templates" in toolbar (📁 icon)
- Shows list of available templates with:
  - Template name
  - Creation date
  - Canvas dimensions
- Click on template to load it into background layer

### 4. **Quick Load Last Background**
- Button: "Last BG" in toolbar (⏮️ icon)
- Instantly loads the most recently used background
- Useful when judge wants same view for consecutive runs

## API Endpoints

### `judge_drawings_api.php`

All endpoints require authentication (judge, head_judge, or admin role).

#### 1. Save Drawing
```
POST /api/judge_drawings_api.php?action=save_drawing
```
**Body:**
```json
{
  "event_id": "3",
  "heat_number": "1",
  "run_number": "1",
  "participant_id": "2158",
  "canvas_width": 1908,
  "canvas_height": 649,
  "background": [array of stroke objects],
  "foreground": [array of stroke objects],
  "notes": "Fell on rail 3"
}
```
**Response:**
```json
{
  "success": true,
  "message": "Drawing saved",
  "drawing_id": 42
}
```

#### 2. Load Drawing
```
GET /api/judge_drawings_api.php?action=load_drawing&event_id=3&heat_number=1&run_number=1&participant_id=2158
```
**Response:**
```json
{
  "success": true,
  "drawing": {
    "id": 42,
    "background": [strokes],
    "foreground": [strokes],
    "canvas_width": 1908,
    "canvas_height": 649,
    "notes": "...",
    "status": "draft"
  }
}
```

#### 3. Save Template
```
POST /api/judge_drawings_api.php?action=save_template
```
**Body:**
```json
{
  "event_id": "3",
  "template_name": "Slopestyle Course A",
  "background": [array of stroke objects],
  "canvas_width": 1908,
  "canvas_height": 649
}
```
**Response:**
```json
{
  "success": true,
  "message": "Template saved: Slopestyle Course A",
  "template_id": 15
}
```

#### 4. List Templates
```
GET /api/judge_drawings_api.php?action=list_templates&event_id=3
```
**Response:**
```json
{
  "success": true,
  "templates": [
    {
      "id": 15,
      "template_name": "Slopestyle Course A",
      "canvas_width": 1908,
      "canvas_height": 649,
      "created_at": "2025-11-17 14:30:00"
    }
  ]
}
```

#### 5. Load Template
```
GET /api/judge_drawings_api.php?action=load_template&template_id=15
```
**Response:**
```json
{
  "success": true,
  "template": {
    "id": 15,
    "name": "Slopestyle Course A",
    "background": [array of stroke objects],
    "canvas_width": 1908,
    "canvas_height": 649
  }
}
```

#### 6. Get Last Background
```
GET /api/judge_drawings_api.php?action=get_last_background&event_id=3
```
**Response:**
```json
{
  "success": true,
  "background": [array of stroke objects],
  "canvas_width": 1908,
  "canvas_height": 649
}
```

## Database Schema

### `judge_drawings` Table
Templates use the same table as regular drawings with these differences:
- `status = 'template'` (instead of 'draft')
- `heat_number = NULL`
- `run_number = NULL`
- `participant_id = NULL`
- `notes` field contains the template name
- `drawing_json` is empty string (only background matters)

## Usage Workflow

### Scenario 1: First Run of the Day
1. Judge opens drawing board
2. Draws the slope/rail layout on background layer
3. Switches to foreground layer
4. Draws the actual situation (fall, foul, etc.)
5. Saves drawing → Both layers saved for this score
6. Clicks "Save BG" → Background saved as template for reuse

### Scenario 2: Next Run, Same View
1. Judge selects new participant
2. Opens drawing board
3. Last used background auto-loads
4. Judge draws new situation on foreground
5. Saves → New drawing created with reused background

### Scenario 3: Different Course Section
1. Judge clicks "Templates"
2. Selects "Rail Section View"
3. Template loads into background
4. Judge draws new situation
5. Saves

### Scenario 4: Editing Previous Drawing
1. Judge opens drawing board for participant they already drew
2. System auto-loads both layers + notes
3. Judge modifies foreground or adds more notes
4. Saves → Updates existing drawing record

## Technical Details

### File Storage
- Background templates: `/drawings/backgrounds/template_{judge_id}_{timestamp}_{random}.json`
- Drawing backgrounds: `/drawings/backgrounds/bg_{event}_{heat}_{run}_{participant}_{timestamp}_{random}.json`
- Drawing foregrounds: `/drawings/scores/fg_{event}_{heat}_{run}_{participant}_{timestamp}_{random}.json`

### Auto-Load Logic
```javascript
async function openDrawingBoard() {
    // 1. Open modal
    // 2. Try to load existing drawing for this participant/heat/run
    //    - If found: Load both layers + notes
    //    - If not found: Load last used background
    // 3. Judge draws/edits
    // 4. Save updates or creates new record
}
```

### Template Metadata
Templates are stored in `judge_drawings` table with:
- `status = 'template'` for easy filtering
- `notes` field = template name (for display)
- `created_at` for sorting
- `judge_id` for ownership (judge can only see their own templates)

## UI Components

### Toolbar Buttons
1. **Last BG** (⏮️): Quick load most recent background
2. **Templates** (📁): Browse and select saved templates
3. **Save BG** (💾): Save current background as new template

### Template Selector Modal
When clicking "Templates", shows:
- List of saved templates
- Template name + creation date
- Canvas dimensions badge
- Click to load

Uses SweetAlert2 if available, otherwise falls back to simple list.

## Future Enhancements

### Potential Features
1. **Share Templates**: Allow head judge to create templates visible to all judges
2. **Template Preview**: Show thumbnail of template before loading
3. **Template Categories**: Organize templates by feature type (slopestyle, big air, etc.)
4. **Template Export/Import**: Share templates between events
5. **Template Editing**: Edit template name/metadata after creation
6. **Template Deletion**: Remove unused templates (UI not yet implemented, but API exists)

### Integration Points
1. **Head Judge Approval**: Display drawings in score review
2. **Results View**: Show drawings alongside scores in reports
3. **Export to PDF**: Include drawings in official results documents
4. **Mobile Optimization**: Touch-friendly template selection

## Testing Checklist

- [x] Save drawing with background + foreground
- [x] Auto-load existing drawing when reopening
- [x] Auto-load last background for new drawing
- [x] Save background as template
- [x] List available templates
- [x] Load template into background
- [ ] Template selection UI (SweetAlert integration)
- [ ] Multiple judges using templates simultaneously
- [ ] Template deletion
- [ ] Large canvas handling (performance test)
- [ ] File permission errors handling

## Notes

- Templates are judge-specific (each judge sees only their own)
- Background layer opacity default: 30% (adjustable via slider)
- Background layer can be locked to prevent accidental edits
- Templates persist across heats and runs
- No limit on number of templates per judge (consider adding cleanup later)
