<?php
require_once 'bootstrap/db.php';
require_once 'app/Models/UserType.php';

echo "<h2>Permission Processing Test</h2>";

// Simulate the processPermissions method
function processPermissions($permissions)
{
    $processed = [];
    
    if (is_array($permissions)) {
        foreach ($permissions as $permission => $value) {
            // Store permissions as flat key-value pairs
            $processed[$permission] = true;
        }
    }
    
    return $processed;
}

// Test with sample data
$testPermissions = [
    'users.view' => '1',
    'users.create' => '1',
    'user_types.view' => '1'
];

echo "<h3>Input:</h3>";
echo "<pre>";
print_r($testPermissions);
echo "</pre>";

$processed = processPermissions($testPermissions);

echo "<h3>Processed:</h3>";
echo "<pre>";
print_r($processed);
echo "</pre>";

echo "<h3>JSON:</h3>";
echo htmlspecialchars(json_encode($processed));

echo "<hr>";

// Test current data from database
$userType = new UserType();
$type = $userType->findById(6); // Regular User

if ($type) {
    echo "<h3>User Type: {$type['name']}</h3>";
    echo "<p><strong>Raw permissions:</strong> " . htmlspecialchars($type['permissions']) . "</p>";
    echo "<p><strong>Permission count:</strong> " . count($type['permissions'] ?? []) . "</p>";
}
?>
