<?php
session_start();

echo "<h2>Direct Controller Test</h2>";

// Test if we can load the controller directly
echo "<h3>1. Testing Controller File Access:</h3>";
$controllerFile = "../app/Controllers/LanguageController.php";
if (file_exists($controllerFile)) {
    echo "<p style='color: green;'>✓ LanguageController.php exists</p>";
    require_once $controllerFile;
    
    echo "<h3>2. Testing Controller Instantiation:</h3>";
    try {
        // Set up session for auth check
        $_SESSION['user_id'] = 1;
        $_SESSION['user_role'] = 'admin';
        
        $controller = new LanguageController();
        echo "<p style='color: green;'>✓ LanguageController instantiated successfully</p>";
        
        echo "<h3>3. Testing create method:</h3>";
        if (method_exists($controller, 'create')) {
            echo "<p style='color: green;'>✓ create method exists</p>";
            
            // Try to call the create method
            echo "<h3>4. Calling create method:</h3>";
            try {
                ob_start();
                $controller->create();
                $output = ob_get_clean();
                echo "<p style='color: green;'>✓ create method executed</p>";
                if (!empty($output)) {
                    echo "<div style='background: #f8f9fa; padding: 10px; border-radius: 5px; margin-top: 10px;'>";
                    echo "<strong>Output:</strong><br>";
                    echo $output;
                    echo "</div>";
                }
            } catch (Exception $e) {
                echo "<p style='color: red;'>✗ Error calling create method: " . $e->getMessage() . "</p>";
            }
        } else {
            echo "<p style='color: red;'>✗ create method does not exist</p>";
        }
        
    } catch (Exception $e) {
        echo "<p style='color: red;'>✗ Error instantiating controller: " . $e->getMessage() . "</p>";
        echo "<p><strong>Error details:</strong> " . $e->getTraceAsString() . "</p>";
    }
} else {
    echo "<p style='color: red;'>✗ LanguageController.php not found at: $controllerFile</p>";
}

echo "<hr>";
echo "<h3>5. Testing Route Manually:</h3>";
require_once '../bootstrap/router.php';

$router = new Router();
$router->get('/languages/create', 'LanguageController@create');

echo "<p>Testing URL: /samanta_crm/languages/create</p>";
try {
    $router->dispatch('/samanta_crm/languages/create', 'GET');
} catch (Exception $e) {
    echo "<p style='color: red;'>Router error: " . $e->getMessage() . "</p>";
}
?>
