<?php
/**
 * Translation Function Diagnostic
 * Simple script to check if translation system is working
 */

// Set error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h2>Translation System Diagnostic</h2>";

// Test 1: Check if session is working
session_start();
echo "<p>✓ Session started</p>";

// Test 2: Load core files
try {
    require_once '../bootstrap/env.php';
    echo "<p>✓ Environment loaded</p>";
} catch (Exception $e) {
    echo "<p>✗ Environment error: " . $e->getMessage() . "</p>";
}

try {
    require_once '../bootstrap/db.php';
    echo "<p>✓ Database connected</p>";
} catch (Exception $e) {
    echo "<p>✗ Database error: " . $e->getMessage() . "</p>";
}

// Test 3: Load translation helper
try {
    require_once '../app/helpers/translation.php';
    echo "<p>✓ Translation helper loaded</p>";
} catch (Exception $e) {
    echo "<p>✗ Translation helper error: " . $e->getMessage() . "</p>";
}

// Test 4: Check if function exists
if (function_exists('__')) {
    echo "<p>✓ Translation function __ exists</p>";
} else {
    echo "<p>✗ Translation function __ NOT found</p>";
}

// Test 5: Set default language
if (!isset($_SESSION['language'])) {
    $_SESSION['language'] = 'en';
}
echo "<p>✓ Language set to: " . $_SESSION['language'] . "</p>";

// Test 6: Test translation
try {
    $test = __('dashboard.title', 'Dashboard');
    echo "<p>✓ Translation test successful: '$test'</p>";
} catch (Exception $e) {
    echo "<p>✗ Translation test failed: " . $e->getMessage() . "</p>";
}

echo "<h3>Translation function is ready to use!</h3>";
echo "<p>You can now use <code>__('key', 'default')</code> in your views.</p>";
echo "<p><a href='/samanta_crm/dashboard'>Go to Dashboard</a></p>";
?>
