<?php
require_once 'bootstrap/db.php';

// Check if we need to set user_type_id for existing users
$stmt = $pdo->query("SELECT id, name, email, user_type_id FROM users");
$users = $stmt->fetchAll();

echo "<h2>User Type Assignment Check</h2>";

foreach ($users as $user) {
    if (empty($user['user_type_id'])) {
        echo "<p>User '{$user['name']}' has no user_type_id. Assigning default...</p>";
        
        // Get first user type ID
        $typeStmt = $pdo->query("SELECT id FROM user_types ORDER BY id LIMIT 1");
        $firstType = $typeStmt->fetch();
        
        if ($firstType) {
            $updateStmt = $pdo->prepare("UPDATE users SET user_type_id = ? WHERE id = ?");
            $updateStmt->execute([$firstType['id'], $user['id']]);
            echo "<p style='color: green;'>✅ Assigned user type {$firstType['id']} to {$user['name']}</p>";
        }
    } else {
        echo "<p style='color: green;'>✅ User '{$user['name']}' has user_type_id: {$user['user_type_id']}</p>";
    }
}

echo "<p><strong>All users now have proper user type assignments.</strong></p>";
?>
