<?php
echo "<h2>Route Debug Information</h2>";

echo "<h3>Current Request Details:</h3>";
echo "<p><strong>REQUEST_URI:</strong> " . ($_SERVER['REQUEST_URI'] ?? 'Not set') . "</p>";
echo "<p><strong>REQUEST_METHOD:</strong> " . ($_SERVER['REQUEST_METHOD'] ?? 'Not set') . "</p>";
echo "<p><strong>PHP_SELF:</strong> " . ($_SERVER['PHP_SELF'] ?? 'Not set') . "</p>";
echo "<p><strong>SCRIPT_NAME:</strong> " . ($_SERVER['SCRIPT_NAME'] ?? 'Not set') . "</p>";

echo "<h3>Test URL Parsing:</h3>";
$testUrl = '/samanta_crm/languages/create';
echo "<p><strong>Test URL:</strong> $testUrl</p>";

// Parse the URL like the router would
$parsedUrl = parse_url($testUrl);
echo "<p><strong>Parsed Path:</strong> " . ($parsedUrl['path'] ?? 'Not set') . "</p>";

// Remove base path
$path = $parsedUrl['path'] ?? '';
if (strpos($path, '/samanta_crm') === 0) {
    $path = substr($path, strlen('/samanta_crm'));
}
echo "<p><strong>Cleaned Path:</strong> $path</p>";

echo "<h3>Router Test:</h3>";
require_once '../bootstrap/router.php';

$router = new Router();
$router->get('/languages/create', 'LanguageController@create');

echo "<p>Router created and route added. Testing dispatch...</p>";

// Test if the route matches
try {
    ob_start();
    $router->dispatch('/samanta_crm/languages/create', 'GET');
    $output = ob_get_clean();
    echo "<p style='color: green;'>Route dispatch successful!</p>";
    if (!empty($output)) {
        echo "<div style='background: #f8f9fa; padding: 10px; border-radius: 5px;'>";
        echo "<strong>Output:</strong><br>";
        echo htmlspecialchars($output);
        echo "</div>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>Route dispatch failed: " . $e->getMessage() . "</p>";
}

echo "<h3>Available Routes in Router:</h3>";
// We need to check what routes are actually registered
echo "<p>Check the Router class implementation...</p>";
?>
