<?php
require_once '../bootstrap/env.php';
require_once '../bootstrap/db.php';
require_once '../bootstrap/translator.php';
require_once '../bootstrap/router.php';

// Start session
session_start();

// Initialize current language
if (!isset($_SESSION['language'])) {
    $_SESSION['language'] = 'en'; // Default language
}

echo "<h2>Debug Router Registration</h2>";

// Initialize router
$router = new Router();

// Add routes one by one and test
echo "<h3>Adding Language Routes:</h3>";

$router->get('/languages', 'LanguageController@index');
echo "<p>✓ Added: GET /languages</p>";

$router->get('/languages/create', 'LanguageController@create');
echo "<p>✓ Added: GET /languages/create</p>";

$router->post('/languages', 'LanguageController@store');
echo "<p>✓ Added: POST /languages</p>";

$router->get('/languages/{id}/edit', 'LanguageController@edit');
echo "<p>✓ Added: GET /languages/{id}/edit</p>";

echo "<h3>Testing Route Dispatch:</h3>";

// Test the create route specifically
echo "<h4>Testing /samanta_crm/languages/create:</h4>";
$_SESSION['user_id'] = 1;
$_SESSION['user_role'] = 'admin';

try {
    ob_start();
    $router->dispatch('/samanta_crm/languages/create', 'GET');
    $output = ob_get_clean();
    echo "<p style='color: green;'>✓ Route dispatched successfully</p>";
    if (!empty($output)) {
        echo "<div style='background: #f8f9fa; padding: 10px; border-radius: 5px;'>";
        echo $output;
        echo "</div>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Route dispatch failed: " . $e->getMessage() . "</p>";
    echo "<pre>" . $e->getTraceAsString() . "</pre>";
}

echo "<h4>Testing /samanta_crm/languages:</h4>";
try {
    ob_start();
    $router->dispatch('/samanta_crm/languages', 'GET');
    $output = ob_get_clean();
    echo "<p style='color: green;'>✓ Index route works</p>";
} catch (Exception $e) {
    echo "<p style='color: red;'>✗ Index route failed: " . $e->getMessage() . "</p>";
}
?>
