<?php
// Start session and include necessary files
session_start();
require_once 'bootstrap/db.php';

echo "<h2>Database Permissions Debug</h2>";

try {
    $stmt = $pdo->prepare('SELECT id, name, permissions FROM user_types ORDER BY id');
    $stmt->execute();
    
    echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
    echo "<tr><th>ID</th><th>Name</th><th>Raw JSON</th><th>Decoded Count</th><th>First Few Keys</th></tr>";
    
    while($row = $stmt->fetch()) {
        $decoded = json_decode($row['permissions'], true);
        $count = is_array($decoded) ? count($decoded) : 0;
        $firstKeys = is_array($decoded) ? implode(', ', array_slice(array_keys($decoded), 0, 3)) : 'N/A';
        
        echo "<tr>";
        echo "<td>" . htmlspecialchars($row['id']) . "</td>";
        echo "<td>" . htmlspecialchars($row['name']) . "</td>";
        echo "<td style='max-width: 200px; overflow-wrap: break-word;'>" . htmlspecialchars($row['permissions']) . "</td>";
        echo "<td>" . $count . "</td>";
        echo "<td>" . htmlspecialchars($firstKeys) . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch(Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
