<?php
session_start();
require_once 'bootstrap/db.php';

echo "<h2>Languages in Database</h2>";

try {
    $stmt = $pdo->query("SELECT * FROM languages ORDER BY id");
    $languages = $stmt->fetchAll();
    
    if (empty($languages)) {
        echo "<p style='color: red;'>No languages found in database!</p>";
        echo "<p>The languages table appears to be empty.</p>";
    } else {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>Code</th><th>Name</th><th>Native Name</th><th>Flag</th><th>Active</th><th>Default</th><th>Created</th></tr>";
        
        foreach ($languages as $lang) {
            echo "<tr>";
            echo "<td>{$lang['id']}</td>";
            echo "<td>{$lang['code']}</td>";
            echo "<td>{$lang['name']}</td>";
            echo "<td>{$lang['native_name']}</td>";
            echo "<td>{$lang['flag']}</td>";
            echo "<td>" . ($lang['is_active'] ? 'Yes' : 'No') . "</td>";
            echo "<td>" . ($lang['is_default'] ? 'Yes' : 'No') . "</td>";
            echo "<td>{$lang['created_at']}</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    echo "<hr>";
    echo "<h3>Table Structure</h3>";
    $stmt = $pdo->query("DESCRIBE languages");
    $columns = $stmt->fetchAll();
    
    echo "<table border='1' style='border-collapse: collapse;'>";
    echo "<tr><th>Field</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th></tr>";
    foreach ($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "<td>{$col['Extra']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}
?>
