<?php 
$title = 'Edit User Type';

// Helper function for category icons
function getCategoryIcon($category) {
    $icons = [
        'Users' => 'users',
        'User_types' => 'user-tag',
        'Languages' => 'globe', 
        'Translations' => 'language',
        'Dashboard' => 'tachometer-alt',
        'System' => 'cogs',
        'Reports' => 'chart-bar',
        'Auth' => 'lock'
    ];
    
    return $icons[$category] ?? 'tags';
}

ob_start(); 
?>

<div class="row justify-content-center">
    <div class="col-md-10">
        <div class="card">
            <div class="card-header">
                <h5 class="card-title mb-0">
                    <i class="fas fa-edit"></i> Edit User Type: 
                    <span class="badge" style="background-color: <?= htmlspecialchars($userType['color']) ?>;">
                        <?= htmlspecialchars($userType['name']) ?>
                    </span>
                </h5>
            </div>
            <div class="card-body">
                <form method="POST" action="/samanta_crm/user-types/<?= $userType['id'] ?>/update">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="name" class="form-label">Name *</label>
                                <input type="text" class="form-control" id="name" name="name" value="<?= htmlspecialchars($userType['name']) ?>" required>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label for="color" class="form-label">Color</label>
                                <input type="color" class="form-control form-control-color" id="color" name="color" value="<?= htmlspecialchars($userType['color']) ?>">
                            </div>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label for="description" class="form-label">Description</label>
                        <textarea class="form-control" id="description" name="description" rows="3"><?= htmlspecialchars($userType['description']) ?></textarea>
                    </div>
                    
                    <div class="mb-3">
                        <div class="form-check">
                            <input class="form-check-input" type="checkbox" id="is_active" name="is_active" <?= $userType['is_active'] ? 'checked' : '' ?>>
                            <label class="form-check-label" for="is_active">
                                Active
                            </label>
                        </div>
                    </div>
                    
                    <hr>
                    
                    <h6 class="mb-3"><i class="fas fa-shield-alt"></i> Permissions</h6>
                    
                    <div class="row">
                        <?php foreach ($permissions as $category => $categoryPermissions): ?>
                        <div class="col-md-6 mb-4">
                            <div class="card bg-light">
                                <div class="card-header py-2">
                                    <h6 class="mb-0">
                                        <i class="fas fa-<?= getCategoryIcon($category) ?>"></i>
                                        <?= htmlspecialchars($category) ?>
                                        <small class="text-muted">(<?= count($categoryPermissions) ?>)</small>
                                    </h6>
                                </div>
                                <div class="card-body py-2">
                                    <?php foreach ($categoryPermissions as $permission): ?>
                                    <?php 
                                    // Get permissions as array, not JSON string
                                    $currentPermissions = $userType['permissions'] ?? [];
                                    if (is_string($currentPermissions)) {
                                        $currentPermissions = json_decode($currentPermissions, true) ?: [];
                                    }
                                    $isChecked = isset($currentPermissions[$permission['key']]) && $currentPermissions[$permission['key']] === true;
                                    ?>
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" 
                                               id="perm_<?= htmlspecialchars($permission['key']) ?>" 
                                               name="permissions[<?= htmlspecialchars($permission['key']) ?>]" 
                                               value="1" <?= $isChecked ? 'checked' : '' ?>>
                                        <label class="form-check-label" for="perm_<?= htmlspecialchars($permission['key']) ?>">
                                            <strong><?= htmlspecialchars($permission['name']) ?></strong>
                                            <?php if (!empty($permission['description'])): ?>
                                            <br><small class="text-muted"><?= htmlspecialchars($permission['description']) ?></small>
                                            <?php endif; ?>
                                        </label>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    </div>
                    
                    <div class="d-flex justify-content-between">
                        <a href="/samanta_crm/user-types" class="btn btn-secondary">
                            <i class="fas fa-arrow-left"></i> Back
                        </a>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Update User Type
                        </button>
                    </div>
                </form>
            </div>
        </div>
        
        <div class="card mt-3">
            <div class="card-body">
                <h6 class="card-title text-muted">User Type Information</h6>
                <p><strong>ID:</strong> <?= $userType['id'] ?></p>
                <p><strong>Created:</strong> <?= date('F j, Y g:i A', strtotime($userType['created_at'])) ?></p>
                <?php if ($userType['updated_at']): ?>
                <p><strong>Last Updated:</strong> <?= date('F j, Y g:i A', strtotime($userType['updated_at'])) ?></p>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php 
$content = ob_get_clean();
$scripts = '
<script>
// Select all permissions in a group
document.querySelectorAll(".card-header").forEach(header => {
    header.style.cursor = "pointer";
    header.addEventListener("click", function() {
        const card = this.closest(".card");
        const checkboxes = card.querySelectorAll("input[type=checkbox]");
        const allChecked = Array.from(checkboxes).every(cb => cb.checked);
        
        checkboxes.forEach(cb => {
            cb.checked = !allChecked;
        });
    });
});
</script>
';
include '../app/Views/layout.php'; 
?>
