<?php $title='Usage History Detail'; ob_start(); ?>
<h1 class="h5 mb-3">Usage Detail: <?=htmlspecialchars($date);?></h1>
<?php if(isset($_SESSION['success'])): ?><div class="alert alert-success"><?=htmlspecialchars($_SESSION['success']); unset($_SESSION['success']);?></div><?php endif; ?>
<a href="/samanta_crm/stock/usage-history" class="btn btn-sm btn-secondary mb-3">&larr; Back to Dates</a>
<form method="post" action="/samanta_crm/stock/rollback-daily" class="mb-3" onsubmit="return confirm('Rollback all usage for <?=$date?>? This will restore stock.');">
	<input type="hidden" name="rollback_date" value="<?=htmlspecialchars($date);?>">
	<button class="btn btn-sm btn-warning">Rollback This Date</button>
</form>
<table class="table table-sm table-bordered">
	<thead><tr><th>Ingredient</th><th class="text-end">Applied Qty</th><th>Unit</th><th><?= __("common.status", "Status") ?></th></tr></thead>
	<tbody>
	<?php foreach($rows as $r): ?>
		<tr>
			<td><?=htmlspecialchars($r['name']);?></td>
			<td class="text-end"><?= (int)round($r['applied_qty']); ?></td>
			<td><?= htmlspecialchars($r['unit'] ?? '') ?></td>
			<td><?=$r['rolled_back']?'<span class="badge bg-secondary">Rolled Back</span>':'<span class="badge bg-success">Applied</span>';?></td>
		</tr>
	<?php endforeach; ?>
	</tbody>
</table>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
