<?php $title='Ingredient Storage Ledger'; ob_start(); ?>
<h1 class="h5 mb-3">Ingredient Storage Ledger</h1>
<div class="mb-2 d-flex gap-2 flex-wrap">
	<a href="/samanta_crm/stock/ingredients" class="btn btn-sm btn-outline-secondary">Summary View</a>
	<div class="btn-group">
		<a href="/samanta_crm/stock/ingredients?mode=ledger&export=csv" class="btn btn-sm btn-outline-success">Export CSV</a>
		<a href="/samanta_crm/stock/ingredients?mode=ledger&export=json" class="btn btn-sm btn-outline-success">Export JSON</a>
		<a href="/samanta_crm/stock/ingredients?mode=ledger&export=xls" class="btn btn-sm btn-outline-success">Excel</a>
		<a href="/samanta_crm/stock/ingredients?mode=ledger&print=1" target="_blank" class="btn btn-sm btn-outline-dark">Print</a>
	</div>
</div>
<table class="table table-sm table-striped table-bordered align-middle">
	<thead class="small">
		<tr>
			<th>ID</th>
			<th>Ingredient</th>
			<th>Location</th>
			<th class="text-end">Qty</th>
			<th>Unit</th>
			<th>Reason</th>
			<th>Ref Date</th>
			<th>Note</th>
			<th>Created</th>
			<th>Updated</th>
		</tr>
	</thead>
	<tbody class="small">
	<?php foreach($rows as $r): ?>
		<tr>
			<td><?= (int)$r['id'] ?></td>
			<td><?= htmlspecialchars($r['name']) ?> <span class="text-muted">#<?= (int)$r['ingredient_id'] ?></span></td>
			<td><?= htmlspecialchars($r['location']) ?></td>
			<td class="text-end"><?= (int)round($r['change_qty']) ?></td>
			<td><?= htmlspecialchars($r['unit'] ?? '') ?></td>
			<td><?= htmlspecialchars($r['reason']) ?></td>
			<td><?= htmlspecialchars($r['ref_date']) ?></td>
			<td><?= htmlspecialchars($r['note'] ?? '') ?></td>
			<td><?= htmlspecialchars(substr($r['created_at'],0,19)) ?></td>
			<td><?= htmlspecialchars(substr($r['updated_at']??'',0,19)) ?></td>
		</tr>
	<?php endforeach; ?>
	</tbody>
</table>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>