<?php
require_once __DIR__ . '/../../../bootstrap/auth.php';
requireLogin();
ob_start();
$title = 'System Settings';
?>
<div class="content">
  <div class="d-flex justify-content-between align-items-center mb-4">
    <h2><i class="fas fa-sliders-h me-2"></i>System Settings</h2>
    <a href="/samanta_crm/dashboard" class="btn btn-secondary btn-sm"><i class="fas fa-arrow-left me-1"></i>Back</a>
  </div>
  <div class="card">
    <div class="card-header d-flex justify-content-between align-items-center">
      <span><i class="fas fa-cog me-1"></i>General</span>
      <button form="settingsForm" type="submit" class="btn btn-sm btn-primary"><i class="fas fa-save me-1"></i><?= __("common.save", "Save") ?></button>
    </div>
    <div class="card-body">
      <form id="settingsForm" method="POST" action="/samanta_crm/settings/save" enctype="multipart/form-data">
        <div class="mb-3">
          <label class="form-label">Site Name</label>
          <input type="text" name="site_name" value="<?= htmlspecialchars($settings['site_name']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Site Logo</label>
          <?php if(!empty($settings['site_logo'])): ?>
            <div class="mb-2">
              <img src="<?= htmlspecialchars($settings['site_logo']) ?>" alt="Site Logo" style="max-height:60px" class="border p-1 bg-white">
            </div>
          <?php endif; ?>
          <input type="file" name="site_logo" accept="image/*" class="form-control">
          <div class="form-text">Allowed: png, jpg, jpeg, gif, webp, svg. Recommended height ≤ 80px.</div>
        </div>
        <div class="mb-3 form-check">
          <input type="checkbox" class="form-check-input" id="showNameLogo" name="show_site_name_with_logo" value="1" <?= $settings['show_site_name_with_logo']==='1'?'checked':'' ?>>
          <label class="form-check-label" for="showNameLogo">Show site name next to logo</label>
        </div>
        <div class="row g-3">
          <div class="col-md-4">
            <label class="form-label">Default Language</label>
            <select name="default_language" class="form-select">
              <?php foreach ($languages as $lang): ?>
                <option value="<?= htmlspecialchars($lang['code']) ?>" <?= $lang['code']===$settings['default_language']?'selected':'' ?>><?= $lang['flag'] ?> <?= htmlspecialchars($lang['native_name'] ?: $lang['name']) ?></option>
              <?php endforeach; ?>
            </select>
          </div>
          <div class="col-md-4">
            <label class="form-label d-block">Maintenance Mode</label>
            <div class="form-check form-switch">
              <input class="form-check-input" type="checkbox" name="maintenance_mode" id="mmode" <?= $settings['maintenance_mode']==='1'?'checked':'' ?>>
              <label class="form-check-label" for="mmode">Enable</label>
            </div>
          </div>
        </div>
        <div class="mt-3">
          <label class="form-label">Maintenance Message</label>
          <textarea name="maintenance_message" rows="3" class="form-control" placeholder="Shown to non-admin users when maintenance is active."><?= htmlspecialchars($settings['maintenance_message']) ?></textarea>
        </div>
      </form>
    </div>
  </div>
</div>
<?php $content = ob_get_clean(); include __DIR__ . '/../layout.php'; ?>
