<?php
require_once __DIR__ . '/../../bootstrap/auth.php';
requireLogin();

// Check report permission
require_once __DIR__ . '/../../app/Models/UserType.php';
$userTypeModel = new UserType();
if (!$userTypeModel->hasPermission($_SESSION['user_type_id'], 'reports_view')) {
    http_response_code(403);
    die('Access denied');
}

$title = __('reports.title');
$currentPage = 'reports';
?>

<?php include __DIR__ . '/../layout.php'; ?>

<div class="content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2><i class="fas fa-chart-bar me-2"></i>Reports Dashboard</h2>
    </div>

    <div class="row">
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-users me-2"></i>User Reports
                    </h5>
                </div>
                <div class="card-body">
                    <p>This is a demo reports module to show automatic permission generation.</p>
                    <p class="text-muted">The system automatically detected this new module and generated permissions for it!</p>
                </div>
            </div>
        </div>
        
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-cog me-2"></i>System Reports
                    </h5>
                </div>
                <div class="card-body">
                    <p>When you created this reports directory, the PermissionScanner automatically:</p>
                    <ul>
                        <li>✅ Generated <code>reports_view</code> permission</li>
                        <li>✅ Generated <code>reports_create</code> permission</li>
                        <li>✅ Generated <code>reports_edit</code> permission</li>
                        <li>✅ Generated <code>reports_delete</code> permission</li>
                        <li>✅ Added them to existing user types</li>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
