<?php $title='Import Products'; ob_start(); ?>
<h3>Import Products</h3>
<p class="text-muted small mb-2">Upload a CSV. You can choose manual column mapping (recommended for new/changed files) or quick auto import (assumes legacy Polish headers). Configure delimiters if your file is not standard comma + quotes.</p>
<form id="importForm" method="POST" action="/samanta_crm/products/import/preview" enctype="multipart/form-data" class="mb-3">
  <div class="mb-3">
    <label class="form-label">CSV File *</label>
    <input type="file" name="csv" accept=".csv,text/csv" class="form-control" required>
  </div>
  <div class="row g-3 mb-2">
    <div class="col-md-3">
      <label class="form-label small mb-1">Field Delimiter</label>
      <select name="field_delim" class="form-select form-select-sm">
        <option value="auto">Auto detect</option>
        <option value=",">Comma (,)</option>
        <option value=";">Semicolon (;)</option>
        <option value="\t">Tab (↹)</option>
        <option value="|">Pipe (|)</option>
      </select>
    </div>
    <div class="col-md-3">
      <label class="form-label small mb-1">Text Delimiter</label>
      <select name="text_delim" class="form-select form-select-sm">
        <option value="auto">Auto detect</option>
        <option value="\"">Double Quote (")</option>
        <option value="'">Single Quote (')</option>
        <option value="none">None</option>
      </select>
    </div>
    <div class="col-md-6">
      <label class="form-label small mb-1">Options</label>
      <div class="form-check small">
        <input class="form-check-input" type="checkbox" name="assume_all_quoted" value="1" id="assumeAllQuoted">
        <label class="form-check-label" for="assumeAllQuoted">Assume all text cells are quoted (skip auto-trim heuristic)</label>
      </div>
    </div>
  </div>
  <div class="d-flex flex-wrap gap-2">
    <button class="btn btn-primary" title="Go to mapping step"><i class="fas fa-columns me-1"></i> Next: Map Columns</button>
    <button type="submit" formaction="/samanta_crm/products/import" class="btn btn-outline-success" title="Attempt direct import using known headers"><i class="fas fa-bolt me-1"></i> Quick Auto Import</button>
    <a href="/samanta_crm/products" class="btn btn-secondary"><?= __("common.cancel", "Cancel") ?></a>
  </div>
  <div class="form-text">Quick Auto Import updates existing products by Code. Manual mapping lets you align any header names to database fields before processing.</div>
</form>
<details class="mb-2">
  <summary class="small fw-bold">Reference: Expected Legacy Columns</summary>
  <table class="table table-sm table-bordered w-auto mb-0 mt-2">
    <thead><tr><th>CSV Column</th><th>Mapped Field</th></tr></thead>
    <tbody>
      <tr><td>Nazwa</td><td>name</td></tr>
      <tr><td>Opis</td><td>description</td></tr>
      <tr><td>Kategoria</td><td>category (auto-created if missing)</td></tr>
      <tr><td>Cena</td><td>price (decimal)</td></tr>
      <tr><td>Za ceną</td><td>price_unit</td></tr>
      <tr><td>Uwagi</td><td>notes</td></tr>
      <tr><td>Produkcja</td><td>production_site</td></tr>
      <tr><td>Ogólny, Kategoria, Piekarnia...</td><td>report_flags[] (presence = set)</td></tr>
      <tr><td>Kod</td><td>code (unique key)</td></tr>
      <tr><td>Order</td><td>sort_order</td></tr>
      <tr><td>Faktor</td><td>factor (decimal)</td></tr>
      <tr><td>Jed. prod.</td><td>production_unit</td></tr>
      <tr><td><?= __("common.status", "Status") ?></td><td>status (active/notactive/blocked)</td></tr>
    </tbody>
  </table>
</details>
<script>
// Simple UX: warn if user chooses Quick Auto Import without typical headers (after file load)
document.querySelector('input[type=file]').addEventListener('change', function(){
  // Could parse first line via FileReader; lightweight check only.
  const file=this.files[0]; if(!file) return;
  const reader=new FileReader();
  reader.onload=e=>{ const firstLine=(e.target.result||'').split(/\r?\n/)[0]; if(firstLine && !/nazwa/i.test(firstLine) && !/kod/i.test(firstLine)){ console.log('Headers look non-legacy – prefer mapping.'); }
  }; reader.readAsText(file.slice(0,2048),'utf-8');
});
</script>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
