<?php $title='Ingredient Storage'; ob_start(); ?>
<div class="d-flex justify-content-between align-items-center mb-3"><h1 class="h5 mb-0"><i class="fas fa-warehouse me-2"></i>Ingredient Storage</h1>
  <a href="/samanta_crm/ingredients" class="btn btn-sm btn-outline-secondary"><i class="fas fa-arrow-left"></i> Ingredients</a></div>
<div class="card mb-4"><div class="card-header py-2"><strong>Add / Update Stock</strong></div>
  <div class="card-body">
    <form method="POST" action="/samanta_crm/ingredient-storage/save" class="row g-2 align-items-end">
      <div class="col-md-3"><label class="form-label small mb-0">Ingredient</label><select name="ingredient_id" class="form-select form-select-sm" required><option value="">-- choose --</option><?php foreach($ingredients as $ing): ?><option value="<?= $ing['id'] ?>"><?= htmlspecialchars($ing['name']) ?></option><?php endforeach; ?></select></div>
      <div class="col-md-2"><label class="form-label small mb-0">Location</label><input name="location" class="form-control form-control-sm" placeholder="Main" required></div>
      <div class="col-md-2"><label class="form-label small mb-0">Quantity</label><input name="quantity" class="form-control form-control-sm" type="number" step="0.001" value="0"></div>
      <div class="col-md-2"><label class="form-label small mb-0">Unit</label><input name="unit" class="form-control form-control-sm" placeholder="kg"></div>
      <div class="col-md-2"><label class="form-label small mb-0">Notes</label><input name="notes" class="form-control form-control-sm"></div>
      <div class="col-md-1"><button class="btn btn-sm btn-primary w-100"><i class="fas fa-save"></i></button></div>
    </form>
  </div></div>
  <div class="card mb-4"><div class="card-header py-2"><strong>Merge Rollback Stock</strong></div>
    <div class="card-body">
      <form method="POST" action="/samanta_crm/ingredient-storage/merge-rollback" class="row g-2 align-items-end">
        <div class="col-md-4"><label class="form-label small mb-0">Ingredient</label><select name="ingredient_id" class="form-select form-select-sm" required><option value="">-- choose --</option><?php foreach($ingredients as $ing): ?><option value="<?= $ing['id'] ?>"><?= htmlspecialchars($ing['name']) ?></option><?php endforeach; ?></select></div>
        <div class="col-md-3"><label class="form-label small mb-0">Target Location</label><input name="target_location" class="form-control form-control-sm" value="Main"></div>
        <div class="col-md-4 small text-muted">Moves quantity from location 'ROLLBACK' into target, then deletes the 'ROLLBACK' entry.</div>
        <div class="col-md-1"><button class="btn btn-sm btn-warning w-100" onclick="return confirm('Merge rollback stock?')"><i class="fas fa-exchange-alt"></i></button></div>
      </form>
    </div></div>
<div class="table-responsive"><table class="table table-sm table-striped align-middle"><thead class="table-light"><tr><th>Ingredient</th><th>Location</th><th class="text-end">Qty</th><th>Unit</th><th>Notes</th><th></th></tr></thead><tbody>
<?php foreach($rows as $r): ?>
  <tr>
    <td><?= htmlspecialchars($r['ingredient_name']) ?></td>
    <td><?= htmlspecialchars($r['location']) ?></td>
    <td class="text-end"><?= $r['quantity']+0 ?></td>
    <td><?= htmlspecialchars($r['unit'] ?: $r['default_unit']) ?></td>
    <td><?= htmlspecialchars($r['notes']) ?></td>
    <td class="text-end" style="width:70px">
      <form method="POST" action="/samanta_crm/ingredient-storage/<?= $r['id'] ?>/delete" onsubmit="return confirm('Delete entry?')" class="d-inline"><button class="btn btn-sm btn-outline-danger"><i class="fas fa-trash"></i></button></form>
    </td>
  </tr>
<?php endforeach; if(!$rows): ?><tr><td colspan="6" class="text-center text-muted">No storage entries</td></tr><?php endif; ?>
</tbody></table></div>
<?php $content=ob_get_clean(); require __DIR__.'/../layout.php'; ?>
