<?php $title='Ingredients'; ob_start(); ?>
<div class="d-flex justify-content-between mb-3"><h3>Ingredients</h3><a href="/samanta_crm/ingredients/create" class="btn btn-primary btn-sm">Add</a></div>
<table class="table table-sm table-striped">
	<thead>
		<tr><th><?= __("common.name", "Name") ?></th><th>Unit</th><th>Supplier</th><th></th></tr>
	</thead>
	<tbody>
		<?php foreach($ingredients as $c): ?>
			<?php $code=$c['unit']; $unitLabel = $code && isset($unitsMap[$code]) ? ($unitsMap[$code]['name'].' ('.$code.')') : htmlspecialchars($code); ?>
					<tr>
						<td><?= htmlspecialchars($c['name']) ?></td>
						<td><?= $unitLabel ?></td>
						<td><?= htmlspecialchars($c['supplier'] ?? '') ?></td>
						<td class="text-end">
					<a class="btn btn-sm btn-outline-primary" href="/samanta_crm/ingredients/<?= $c['id'] ?>/edit"><?= __("common.edit", "Edit") ?></a>
					<form method="POST" action="/samanta_crm/ingredients/<?= $c['id'] ?>/delete" class="d-inline" onsubmit="return confirm('Delete?')">
						<button class="btn btn-sm btn-outline-danger">Del</button>
					</form>
				</td>
			</tr>
		<?php endforeach; ?>
	</tbody>
</table>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
