<?php $title=__('ingredients.edit_ingredient', 'Edit Ingredient'); ob_start(); ?>
<h3><?= __('ingredients.edit_ingredient', 'Edit Ingredient') ?></h3>
<?php if(isset($locationStocks)): $main=(int)round($locationStocks['MAIN']??0); $rollback=(int)round($locationStocks['ROLLBACK']??0); $total=$main+$rollback; ?>
<div class="mb-3 small">
  <strong><?= __('ingredients.location_stock', 'Location Stock') ?>:</strong>
  <span class="badge bg-primary"><?= __('ingredients.main', 'Main') ?>: <?=$main?></span>
  <span class="badge bg-warning text-dark"><?= __('ingredients.rollback', 'Rollback') ?>: <?=$rollback?></span>
  <span class="badge bg-secondary"><?= __('common.total', 'Total') ?>: <?=$total?></span>
</div>
<?php endif; ?>
<div class="card mb-3">
  <div class="card-header py-2 small fw-bold"><?= __('ingredients.quick_adjust_stock', 'Quick Adjust Stock (Location)') ?></div>
  <div class="card-body py-2">
    <form class="row g-2 align-items-end" method="post" action="/samanta_crm/storage/adjust">
      <input type="hidden" name="ingredient_id" value="<?=$ingredient['id']?>">
      <input type="hidden" name="return_to" value="/samanta_crm/ingredients/<?=$ingredient['id']?>/edit">
      <div class="col-4 col-md-2">
        <label class="form-label small mb-1"><?= __('common.quantity', 'Quantity') ?> (+/-)</label>
        <input type="text" name="quantity" class="form-control form-control-sm" placeholder="<?= __('ingredients.qty_example', 'e.g. 5') ?>" required>
      </div>
      <div class="col-4 col-md-2">
        <label class="form-label small mb-1"><?= __('ingredients.location', 'Location') ?></label>
        <select name="location" class="form-select form-select-sm">
          <option value="MAIN"><?= __('ingredients.main', 'MAIN') ?></option>
          <option value="ROLLBACK"><?= __('ingredients.rollback', 'ROLLBACK') ?></option>
        </select>
      </div>
      <div class="col-8 col-md-4">
        <label class="form-label small mb-1"><?= __('common.note', 'Note') ?></label>
        <input type="text" name="note" class="form-control form-control-sm" placeholder="<?= __('ingredients.optional_note', 'Optional note') ?>">
      </div>
      <div class="col-4 col-md-2">
        <label class="form-label small mb-1">&nbsp;</label>
        <button class="btn btn-sm btn-primary w-100"><?= __('common.apply', 'Apply') ?></button>
      </div>
    </form>
    <div class="small text-muted mt-1"><?= __('ingredients.adjust_hint', 'Positive adds, negative subtracts. Applies only to selected location.') ?></div>
  </div>
</div>
<?php if(!empty($movements)): $colName = isset($movements[0]['change_qty'])?'change_qty':'quantity'; ?>
<div class="card mb-3">
  <div class="card-header py-2 small fw-bold"><?= __('ingredients.recent_movements', 'Recent Movements') ?></div>
  <div class="table-responsive">
    <table class="table table-sm table-striped mb-0">
      <thead class="small"><tr><th><?= __('common.date', 'Date') ?></th><th><?= __('ingredients.ref_date', 'Ref Date') ?></th><th><?= __('ingredients.location', 'Location') ?></th><th class="text-end"><?= __('common.quantity', 'Qty') ?></th><th><?= __('ingredients.reason', 'Reason') ?></th><th><?= __('common.note', 'Note') ?></th></tr></thead>
      <tbody class="small">
      <?php foreach($movements as $m): ?>
        <tr>
          <td><?= htmlspecialchars(substr($m['created_at']??'',0,19)) ?></td>
          <td><?= htmlspecialchars($m['ref_date']??'') ?></td>
          <td><?= htmlspecialchars($m['location']??'') ?></td>
          <td class="text-end"><?= (int)round($m[$colName]??0) ?></td>
          <td><?= htmlspecialchars($m['reason']??'') ?></td>
          <td><?= htmlspecialchars($m['note']??$m['notes']??'') ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>
<?php endif; ?>
<form method="POST" action="/samanta_crm/ingredients/<?= $ingredient['id'] ?>/update">
  <div class="mb-2">
    <label class="form-label">Name *</label>
    <input name="name" value="<?= htmlspecialchars($ingredient['name']) ?>" class="form-control form-control-sm" required>
  </div>
  <div class="mb-2">
    <label class="form-label">Unit</label>
    <select name="unit_code" class="form-select form-select-sm">
      <option value="">-- None --</option>
      <?php foreach(($units??[]) as $u): $sel = ($ingredient['unit']??'')===$u['code']?'selected':''; ?>
        <option value="<?= htmlspecialchars($u['code']) ?>" <?= $sel ?>><?= htmlspecialchars($u['name']) ?> (<?= htmlspecialchars($u['code']) ?>)</option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-2">
    <label class="form-label">Supplier</label>
    <input name="supplier" value="<?= htmlspecialchars($ingredient['supplier'] ?? '') ?>" class="form-control form-control-sm" placeholder="Supplier name">
  </div>
  <div class="mb-2">
    <label class="form-label">Notes</label>
    <textarea name="notes" class="form-control form-control-sm" rows="2"><?= htmlspecialchars($ingredient['notes']) ?></textarea>
  </div>
  <button class="btn btn-primary"><?= __("common.update", "Update") ?></button> <a href="/samanta_crm/ingredients" class="btn btn-secondary"><?= __("common.cancel", "Cancel") ?></a>
</form>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
