<?php $title='Add Ingredient'; ob_start(); ?>
<h3>Add Ingredient</h3>
<form method="POST" action="/samanta_crm/ingredients">
  <div class="mb-2">
    <label class="form-label">Name *</label>
    <input name="name" class="form-control form-control-sm" required>
  </div>
  <div class="mb-2">
    <label class="form-label">Unit</label>
    <select name="unit_code" class="form-select form-select-sm">
      <option value="">-- None --</option>
      <?php foreach(($units??[]) as $u): ?>
        <option value="<?= htmlspecialchars($u['code']) ?>"><?= htmlspecialchars($u['name']) ?> (<?= htmlspecialchars($u['code']) ?>)</option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="mb-2">
    <label class="form-label">Supplier</label>
    <input name="supplier" class="form-control form-control-sm" placeholder="Supplier name">
  </div>
  <div class="mb-2">
    <label class="form-label">Notes</label>
    <textarea name="notes" class="form-control form-control-sm" rows="2"></textarea>
  </div>
  <button class="btn btn-primary"><?= __("common.save", "Save") ?></button> <a href="/samanta_crm/ingredients" class="btn btn-secondary"><?= __("common.cancel", "Cancel") ?></a>
</form>
<?php $content=ob_get_clean(); include '../app/Views/layout.php'; ?>
