<?php
class Customer {
    private $pdo; public function __construct(){ $this->pdo=$GLOBALS['pdo']; }
    public function all(){ return $this->pdo->query("SELECT * FROM customers ORDER BY name ASC")->fetchAll(); }
    public function find($id){ $st=$this->pdo->prepare("SELECT * FROM customers WHERE id=?"); $st->execute([$id]); return $st->fetch(); }
    public function create($data){ $st=$this->pdo->prepare("INSERT INTO customers (name,email,phone,address,notes,status,created_at) VALUES (?,?,?,?,?,?,NOW())"); return $st->execute([
        $data['name'],$data['email']??null,$data['phone']??null,$data['address']??null,$data['notes']??null,$data['status']??'active'
    ]); }
    public function update($id,$data){ $st=$this->pdo->prepare("UPDATE customers SET name=?,email=?,phone=?,address=?,notes=?,status=?,updated_at=NOW() WHERE id=?"); return $st->execute([
        $data['name'],$data['email']??null,$data['phone']??null,$data['address']??null,$data['notes']??null,$data['status']??'active',$id
    ]); }
    public function delete($id){ $st=$this->pdo->prepare("DELETE FROM customers WHERE id=?"); return $st->execute([$id]); }
    // Relations management
    public function syncCategories($id,$catIds){ $this->pdo->beginTransaction(); try { $stDel=$this->pdo->prepare("DELETE FROM customer_category_access WHERE customer_id=?"); $stDel->execute([$id]); if($catIds){ $ins=$this->pdo->prepare("INSERT INTO customer_category_access (customer_id,category_id) VALUES (?,?)"); foreach($catIds as $cid){ if(!$cid) continue; $ins->execute([$id,$cid]); } } $this->pdo->commit(); } catch(Exception $e){ $this->pdo->rollBack(); }
    }
    public function syncBlockedProducts($id,$prodIds){ $this->pdo->beginTransaction(); try { $this->pdo->prepare("DELETE FROM customer_blocked_products WHERE customer_id=?")->execute([$id]); if($prodIds){ $ins=$this->pdo->prepare("INSERT INTO customer_blocked_products (customer_id,product_id) VALUES (?,?)"); foreach($prodIds as $pid){ if(!$pid) continue; $ins->execute([$id,$pid]); } } $this->pdo->commit(); } catch(Exception $e){ $this->pdo->rollBack(); }
    }
    public function syncAdditionalProducts($id,$prodIds){ $this->pdo->beginTransaction(); try { $this->pdo->prepare("DELETE FROM customer_additional_products WHERE customer_id=?")->execute([$id]); if($prodIds){ $ins=$this->pdo->prepare("INSERT INTO customer_additional_products (customer_id,product_id) VALUES (?,?)"); foreach($prodIds as $pid){ if(!$pid) continue; $ins->execute([$id,$pid]); } } $this->pdo->commit(); } catch(Exception $e){ $this->pdo->rollBack(); }
    }
    public function categories($id){ $st=$this->pdo->prepare("SELECT c.* FROM categories c JOIN customer_category_access a ON a.category_id=c.id WHERE a.customer_id=? ORDER BY c.name"); $st->execute([$id]); return $st->fetchAll(); }
    public function blockedProducts($id){ $st=$this->pdo->prepare("SELECT p.* FROM products p JOIN customer_blocked_products b ON b.product_id=p.id WHERE b.customer_id=? ORDER BY p.name"); $st->execute([$id]); return $st->fetchAll(); }
    public function additionalProducts($id){ $st=$this->pdo->prepare("SELECT p.* FROM products p JOIN customer_additional_products a ON a.product_id=p.id WHERE a.customer_id=? ORDER BY p.name"); $st->execute([$id]); return $st->fetchAll(); }
    // Users
    public function users($id){ $st=$this->pdo->prepare("SELECT u.* FROM users u JOIN customer_users cu ON cu.user_id=u.id WHERE cu.customer_id=? ORDER BY u.name"); $st->execute([$id]); return $st->fetchAll(); }
    public function syncUsers($id,$userIds){ $this->pdo->beginTransaction(); try { $this->pdo->prepare("DELETE FROM customer_users WHERE customer_id=?")->execute([$id]); if($userIds){ $ins=$this->pdo->prepare("INSERT INTO customer_users (customer_id,user_id) VALUES (?,?)"); foreach($userIds as $uid){ if(!$uid) continue; $ins->execute([$id,$uid]); } } $this->pdo->commit(); } catch(Exception $e){ $this->pdo->rollBack(); } }
    // Utility counts for summaries
    public function relationCounts($id){
        $counts=['categories'=>0,'blocked'=>0,'additional'=>0,'users'=>0];
        $st=$this->pdo->prepare("SELECT COUNT(*) FROM customer_category_access WHERE customer_id=?"); $st->execute([$id]); $counts['categories']=(int)$st->fetchColumn();
        $st=$this->pdo->prepare("SELECT COUNT(*) FROM customer_blocked_products WHERE customer_id=?"); $st->execute([$id]); $counts['blocked']=(int)$st->fetchColumn();
        $st=$this->pdo->prepare("SELECT COUNT(*) FROM customer_additional_products WHERE customer_id=?"); $st->execute([$id]); $counts['additional']=(int)$st->fetchColumn();
        $st=$this->pdo->prepare("SELECT COUNT(*) FROM customer_users WHERE customer_id=?"); $st->execute([$id]); $counts['users']=(int)$st->fetchColumn();
        return $counts; }
}
