<?php
require_once '../app/Models/Restock.php';
require_once '../app/Models/Ingredient.php';
require_once '../app/Models/IngredientStorage.php';
class RestockController {
	private $restock; private $ingredient; private $storage;
	public function __construct(){ $this->auth(); $this->restock=new Restock(); $this->ingredient=new Ingredient(); $this->storage=new IngredientStorage(); }
	private function auth(){ if(!isset($_SESSION['user_id'])){ header('Location:/samanta_crm/login'); exit; } }
	private function view($v,$d=[]){ extract($d); require_once "../app/Views/$v.php"; }
	public function index(){ $list=$this->restock->all(); $this->view('restocks/index',[ 'restocks'=>$list ]); }
	public function create(){ $this->view('restocks/create',[ 'ingredients'=>$this->ingredient->all() ]); }
		public function store(){ if($_SERVER['REQUEST_METHOD']!=='POST'){ header('Location:/samanta_crm/restocks'); return; }
		$data=[
						'restock_date'=>($_POST['restock_date']??'')?:date('Y-m-d'),
						'supplier'=>$_POST['supplier']??null,
						'notes'=>$_POST['notes']??null,
						'created_by'=>$_SESSION['user_id']??null
				];
		$id=$this->restock->create($data);
		if($id){
			$items=$this->collectItems();
			$this->restock->replaceItems($id,$items);
			foreach($items as $it){
				$this->storage->add($it['ingredient_id'],$it['quantity'],'restock','Restock #'.$id,$it['location'],$data['restock_date']);
			}
			$_SESSION['success']='Restock created';
		} else { $_SESSION['error']='Failed to create restock'; }
		header('Location:/samanta_crm/restocks');
	}
	public function show($id){ $r=$this->restock->find($id); if(!$r){ $_SESSION['error']='Restock not found'; header('Location:/samanta_crm/restocks'); return; } $items=$this->restock->items($id); $this->view('restocks/show',[ 'restock'=>$r,'items'=>$items ]); }
	public function edit($id){ $r=$this->restock->find($id); if(!$r){ $_SESSION['error']='Restock not found'; header('Location:/samanta_crm/restocks'); return; } $items=$this->restock->items($id); $this->view('restocks/edit',[ 'restock'=>$r,'items'=>$items,'ingredients'=>$this->ingredient->all() ]); }
	public function update($id){ if($_SERVER['REQUEST_METHOD']!=='POST'){ header('Location:/samanta_crm/restocks'); return; } $r=$this->restock->find($id); if(!$r){ $_SESSION['error']='Restock not found'; header('Location:/samanta_crm/restocks'); return; }
		$data=[ 'restock_date'=>($_POST['restock_date']??'')?:date('Y-m-d'),'supplier'=>$_POST['supplier']??null,'notes'=>$_POST['notes']??null ];
		$this->restock->update($id,$data);
		$items=$this->collectItems();
		$this->restock->replaceItems($id,$items);
		// NOTE: Stock adjustments on edit are NOT auto-adjusted (simplification). Future: diff old/new and adjust storage ledger.
		$_SESSION['success']='Restock updated';
		header('Location:/samanta_crm/restocks/'.$id);
	}
	public function delete($id){ $this->restock->delete($id); $_SESSION['success']='Restock deleted'; header('Location:/samanta_crm/restocks'); }
	private function collectItems(){
		$items=[]; if(!isset($_POST['item_ingredient_id'])) return $items;
		foreach($_POST['item_ingredient_id'] as $i=>$ing){ $ingId=(int)$ing; if(!$ingId) continue; $qty=(float)str_replace(',','.', $_POST['item_qty'][$i]??0); if($qty<=0) continue; $loc=$_POST['item_location'][$i]??'MAIN'; $items[]=['ingredient_id'=>$ingId,'quantity'=>$qty,'location'=>$loc]; }
		return $items;
	}
}
