# Samanta CRM

A modern Customer Relationship Management system built with PHP, JavaScript, and MySQL.

## Features

- **User Authentication & Authorization**
  - Secure login/logout system
  - Role-based access control (Admin/User)
  - Session management

- **User Management**
  - Create, read, update, delete users
  - User profiles and roles
  - Password management

- **Dashboard & Analytics**
  - Real-time statistics
  - User activity tracking
  - System information

- **Modern UI/UX**
  - Responsive Bootstrap 5 design
  - Interactive JavaScript components
  - Mobile-friendly interface

## Technology Stack

- **Backend**: PHP 7.4+
- **Frontend**: HTML5, CSS3, JavaScript (ES6+)
- **Database**: MySQL 5.7+
- **Framework**: Bootstrap 5
- **Icons**: Font Awesome 6

## Installation

1. **Clone or Download**
   ```
   Place files in your web server directory (e.g., htdocs/samanta_crm)
   ```

2. **Database Setup**
   - Ensure MySQL is running
   - Visit: http://your-domain/samanta_crm/install.php
   - Follow the installation wizard

3. **Configuration**
   - Update database credentials in `bootstrap/db.php` if needed
   - Modify app settings in `bootstrap/env.php`

4. **Apache Configuration**
   - Ensure mod_rewrite is enabled
   - The `.htaccess` file handles URL routing

## Default Login

- **Email**: admin@example.com
- **Password**: password

## Project Structure

```
samanta_crm/
├── app/
│   ├── Controllers/          # Application controllers
│   ├── Models/              # Data models
│   └── Views/               # HTML templates
├── bootstrap/               # Application bootstrap files
│   ├── db.php              # Database configuration
│   ├── env.php             # Environment settings
│   └── router.php          # URL routing
├── public/                 # Web accessible files
│   ├── assets/             # CSS, JS, images
│   ├── index.php           # Application entry point
│   └── install.php         # Database installer
└── README.md
```

## Features Overview

### Authentication System
- Secure password hashing
- Session-based authentication
- Role-based access control
- Automatic session cleanup

### User Management
- Complete CRUD operations
- User roles (Admin/User)
- Profile management
- Password updates

### Dashboard
- User statistics
- System information
- Quick actions
- Recent activity

### Responsive Design
- Mobile-first approach
- Bootstrap 5 components
- Custom CSS styling
- Interactive elements

## API Endpoints (Future Enhancement)

The system is designed to support RESTful API endpoints:

- `GET /api/users` - List users
- `POST /api/users` - Create user
- `GET /api/users/{id}` - Get user
- `PUT /api/users/{id}` - Update user
- `DELETE /api/users/{id}` - Delete user

## Security Features

- Password hashing (PHP password_hash)
- SQL injection prevention (PDO prepared statements)
- XSS protection (HTML escaping)
- CSRF protection (can be enhanced)
- Session security

## Browser Support

- Chrome (latest)
- Firefox (latest)
- Safari (latest)
- Edge (latest)
- Internet Explorer 11+

## Development

### Requirements
- PHP 7.4 or higher
- MySQL 5.7 or higher
- Apache with mod_rewrite
- Modern web browser

### Local Development
1. Set up XAMPP/WAMP/LAMP
2. Configure virtual host (optional)
3. Run database installer
4. Start development

## Contributing

1. Fork the repository
2. Create a feature branch
3. Make your changes
4. Test thoroughly
5. Submit a pull request

## License

This project is open source and available under the [MIT License](LICENSE).

## Support

For support and questions:
- Create an issue on GitHub
- Check the documentation
- Review the code comments

## Changelog

### Version 1.0.0
- Initial release
- User authentication system
- User management interface
- Dashboard with statistics
- Responsive design
- Database installer

---

**Created with ❤️ for modern web development**
