jQuery(document).ready(function($) {
    
    // Upload form submission
    $('#samanta-upload-form').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData();
        var fileInput = $('#menu-file')[0];
        
        if (fileInput.files.length === 0) {
            showMessage('Wybierz plik JSON', 'error');
            return;
        }
        
        formData.append('menu_file', fileInput.files[0]);
        formData.append('action', 'samanta_upload_menu');
        formData.append('nonce', samantaMenu.nonce);
        
        showMessage('Wgrywanie...', 'info');
        
        $.ajax({
            url: samantaMenu.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showMessage('Menu wgrane pomyślnie: ' + response.data.location, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showMessage('Błąd: ' + response.data, 'error');
                }
            },
            error: function() {
                showMessage('Błąd połączenia z serwerem', 'error');
            }
        });
    });
    
    // Delete menu
    $('.delete-menu').on('click', function() {
        if (!confirm('Czy na pewno chcesz usunąć to menu?')) {
            return;
        }
        
        var locationId = $(this).data('location');
        var $row = $(this).closest('tr');
        
        $.ajax({
            url: samantaMenu.ajax_url,
            type: 'POST',
            data: {
                action: 'samanta_delete_menu',
                nonce: samantaMenu.nonce,
                location_id: locationId
            },
            success: function(response) {
                if (response.success) {
                    $row.fadeOut(400, function() {
                        $(this).remove();
                    });
                } else {
                    alert('Błąd: ' + response.data);
                }
            }
        });
    });
    
    // Copy shortcode
    $('.copy-shortcode').on('click', function() {
        var shortcode = $(this).data('shortcode');
        navigator.clipboard.writeText(shortcode).then(function() {
            alert('Shortcode skopiowany!');
        });
    });
    
    // Upload HTML form submission
    $('#samanta-upload-html-form').on('submit', function(e) {
        e.preventDefault();
        
        var formData = new FormData();
        var fileInput = $('#html-file')[0];
        
        if (fileInput.files.length === 0) {
            showHtmlMessage('Wybierz plik HTML', 'error');
            return;
        }
        
        formData.append('html_file', fileInput.files[0]);
        formData.append('action', 'samanta_upload_standalone_html');
        formData.append('nonce', samantaMenu.nonce);
        
        showHtmlMessage('Wgrywanie...', 'info');
        
        $.ajax({
            url: samantaMenu.ajax_url,
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            success: function(response) {
                if (response.success) {
                    showHtmlMessage('HTML wgrane pomyślnie: ' + response.data.location_name, 'success');
                    setTimeout(function() {
                        location.reload();
                    }, 1500);
                } else {
                    showHtmlMessage('Błąd: ' + response.data, 'error');
                }
            },
            error: function() {
                showHtmlMessage('Błąd połączenia z serwerem', 'error');
            }
        });
    });
    
    // Delete standalone menu
    $('.delete-standalone').on('click', function() {
        if (!confirm('Czy na pewno chcesz usunąć to menu?')) {
            return;
        }
        
        var menuId = $(this).data('menu-id');
        var $row = $(this).closest('tr');
        
        $.ajax({
            url: samantaMenu.ajax_url,
            type: 'POST',
            data: {
                action: 'samanta_delete_standalone_html',
                nonce: samantaMenu.nonce,
                menu_id: menuId
            },
            success: function(response) {
                if (response.success) {
                    $row.fadeOut(400, function() {
                        $(this).remove();
                    });
                } else {
                    alert('Błąd: ' + response.data);
                }
            }
        });
    });
    
    function showMessage(message, type) {
        var className = type === 'success' ? 'success-message' : 
                       type === 'error' ? 'error-message' : 'info-message';
        
        $('#upload-message').html('<div class="' + className + '">' + message + '</div>');
    }
    
    function showHtmlMessage(message, type) {
        var className = type === 'success' ? 'success-message' : 
                       type === 'error' ? 'error-message' : 'info-message';
        
        $('#upload-html-message').html('<div class="' + className + '">' + message + '</div>');
    }
});

// Tab switching
function switchTab(event, tabId) {
    event.preventDefault();
    
    // Hide all tabs
    var tabs = document.querySelectorAll('.tab-content');
    tabs.forEach(function(tab) {
        tab.classList.remove('active');
        tab.style.display = 'none';
    });
    
    // Show selected tab
    var selectedTab = document.getElementById(tabId);
    if (selectedTab) {
        selectedTab.classList.add('active');
        selectedTab.style.display = 'block';
    }
    
    // Update nav tabs
    var navTabs = document.querySelectorAll('.nav-tab');
    navTabs.forEach(function(tab) {
        tab.classList.remove('nav-tab-active');
    });
    event.target.classList.add('nav-tab-active');
}
