<?php
if (!defined('ABSPATH')) {
    exit;
}
?>

<div class="samanta-locations-selector">
    <h2>Wybierz Lokalizację</h2>
    
    <div class="locations-grid">
        <?php foreach ($menus as $location_id => $menu): ?>
            <div class="location-card">
                <h3><?php echo esc_html($menu['location']['name']); ?></h3>
                <p><?php echo esc_html($menu['location']['address'] ?? ''); ?></p>
                
                <?php if (!empty($menu['location']['phone'])): ?>
                    <p><strong>Tel:</strong> <?php echo esc_html($menu['location']['phone']); ?></p>
                <?php endif; ?>
                
                <a href="?location=<?php echo esc_attr($location_id); ?>" class="btn btn-primary">
                    Zobacz Menu
                </a>
            </div>
        <?php endforeach; ?>
    </div>
</div>

<style>
.samanta-locations-selector {
    padding: 40px 20px;
}

.samanta-locations-selector h2 {
    text-align: center;
    margin-bottom: 40px;
    font-size: 2.5rem;
}

.locations-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(300px, 1fr));
    gap: 30px;
    max-width: 1200px;
    margin: 0 auto;
}

.location-card {
    background: white;
    border-radius: 12px;
    padding: 30px;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    text-align: center;
}

.location-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 15px rgba(0,0,0,0.2);
}

.location-card h3 {
    color: #2c3e50;
    margin-bottom: 15px;
    font-size: 1.5rem;
}

.location-card p {
    color: #7f8c8d;
    margin-bottom: 10px;
}

.location-card .btn {
    margin-top: 20px;
    padding: 12px 30px;
    background: #3498db;
    color: white;
    text-decoration: none;
    border-radius: 6px;
    display: inline-block;
    transition: background 0.3s ease;
}

.location-card .btn:hover {
    background: #2980b9;
}
</style>
