# WordPress Plugin Update - Standalone HTML Support

## What's New?

The WordPress plugin now supports uploading **complete standalone HTML files** directly from the `/versions` export feature.

## Why This Matters

✅ **100% Identical UI** - Menu looks exactly like standalone version  
✅ **Full Functionality** - Cart, share, lightbox all work perfectly  
✅ **Zero Configuration** - Just upload and go  
✅ **Easy Maintenance** - Re-export and re-upload to update  

## Changes Made

### 1. Plugin Core (`samanta-menu.php`)
- Added `ajax_upload_standalone_html()` - handles HTML file uploads
- Added `ajax_delete_standalone_html()` - handles HTML deletion
- Added `standalone_shortcode()` - renders standalone HTML menus
- New storage: `samanta_menu_standalone_html` WordPress option

### 2. Admin Page (`admin/admin-page.php`)
- Added tabbed interface: "JSON Menus" | "Standalone HTML"
- New upload form for HTML files
- Table showing uploaded standalone menus
- Shortcode examples and usage instructions

### 3. Admin JavaScript (`assets/admin.js`)
- Added HTML upload handler
- Added standalone menu deletion handler
- Tab switching functionality
- Separate message areas for JSON and HTML uploads

### 4. Documentation
- Created `STANDALONE_USAGE.md` - complete usage guide
- Updated main `README.md` - highlights new feature
- This summary document

## How It Works

```
CRM System (/versions)
    ↓ [Export "📄 HTML"]
Complete HTML file (with CSS, JS, cart, share)
    ↓ [Upload to WordPress]
WordPress database (wp_options)
    ↓ [Shortcode: [samanta_standalone id="xxx"]]
Embedded in WordPress page
    ✓ Full standalone functionality preserved
```

## Usage Example

### In CRM:
1. Go to `/samanta_crm/versions`
2. Select location "Cukiernia Kościuszki"
3. Create snapshot
4. Download HTML (📄 button)

### In WordPress:
1. Admin → Menu Lokali → "Standalone HTML" tab
2. Upload the HTML file
3. Copy shortcode: `[samanta_standalone id="menu_abc123"]`

### On WordPress Page:
1. Edit page (e.g., "/menu-kosciuszki")
2. Paste shortcode
3. Publish
4. Done! Menu looks identical to standalone version

## Benefits Over JSON Method

| Feature | JSON Method | Standalone HTML |
|---------|-------------|-----------------|
| Setup complexity | Medium | Very Easy |
| Visual match | Custom | 100% Identical ✅ |
| Cart feature | Needs coding | Built-in ✅ |
| Share feature | Needs coding | Built-in ✅ |
| Updates | Template edits | Re-upload HTML |

## Recommended Workflow

1. **For new locations**: Use Standalone HTML
2. **For updates**: Create new snapshot → Download HTML → Re-upload
3. **For multiple locations**: Upload multiple HTML files, each gets unique ID

## Technical Notes

### Storage
- HTML content stored in `wp_options` table
- Key: `samanta_menu_standalone_html`
- Structure: `[menu_id => [location_name, html_content, uploaded_at, file_name]]`

### Rendering
- Extracts `<style>` and `<script>` from HTML
- Embeds in WordPress page within container div
- Fallback to iframe if extraction fails
- All standalone features (cart, share, language toggle) work natively

### Performance
- HTML cached in database
- No external file dependencies
- Self-contained CSS and JavaScript
- Fast loading

## Files Modified

1. `samanta-menu/samanta-menu.php` - Core plugin file
2. `samanta-menu/admin/admin-page.php` - Admin interface
3. `samanta-menu/assets/admin.js` - Admin JavaScript
4. `samanta-menu/README.md` - Plugin documentation

## Files Created

1. `STANDALONE_USAGE.md` - Detailed usage guide
2. `UPDATE_SUMMARY.md` - This file

## Next Steps

1. ✅ Test HTML upload in WordPress admin
2. ✅ Test shortcode rendering on page
3. ✅ Verify cart functionality works
4. ✅ Verify share functionality works
5. ✅ Test with multiple locations
6. Package updated plugin as ZIP

## Backwards Compatibility

✅ **100% Compatible** - Original JSON method still works  
✅ No breaking changes  
✅ Existing shortcodes unaffected  

Users can continue using JSON method or switch to standalone HTML.
