# Samanta Menu WordPress Plugin - Standalone HTML Feature

## Overview

The WordPress plugin now supports **two methods** for displaying menus:

### Method 1: JSON Upload (Original)
- Upload JSON files exported from CRM
- Uses WordPress plugin templates
- Good control and customization

### Method 2: Standalone HTML Upload (NEW - RECOMMENDED)
- Upload complete HTML files from `/versions` export
- **100% identical** to standalone version
- Full cart and share functionality included
- Zero configuration needed

## Why Use Standalone HTML Method?

✅ **Perfect Match**: Looks exactly like standalone version  
✅ **Full Features**: Cart, share, lightbox - everything works  
✅ **Easy Update**: Just re-export and re-upload HTML  
✅ **Zero Config**: No template adjustments needed  
✅ **Self-contained**: All CSS/JS embedded in HTML

## How to Use

### Step 1: Export Standalone HTML from CRM

1. Go to `/samanta_crm/versions` in your CRM
2. Select a location
3. Click "Create New Snapshot"
4. Click the "📄 HTML" button to download standalone HTML file
5. Save the file (e.g., `menu-location-name.html`)

### Step 2: Upload to WordPress

1. Log into WordPress admin
2. Go to **Menu Lokali** in admin sidebar
3. Click the **"Standalone HTML"** tab
4. Click "Choose File" and select your HTML file
5. Click "Wgraj HTML"
6. Copy the generated shortcode (e.g., `[samanta_standalone id="menu_xxxxx"]`)

### Step 3: Add to WordPress Page

1. Edit any page/post
2. Add the shortcode: `[samanta_standalone id="menu_xxxxx"]`
3. Publish!

## Shortcode Options

### Display specific menu:
```
[samanta_standalone id="menu_12345"]
```

### Display menu list (for multiple locations):
```
[samanta_standalone]
```
This will show links to all uploaded menus.

### Dynamic menu via URL:
Create a single page with `[samanta_standalone]` and users can access:
- `yoursite.com/menu/?menu_id=menu_12345`
- `yoursite.com/menu/?menu_id=menu_67890`

## Features Included in Standalone HTML

✅ Language toggle (PL/EN)  
✅ Cart system with localStorage  
✅ Share via WhatsApp, SMS, Email, Messenger  
✅ Shared cart links  
✅ Image lightbox  
✅ Smooth animations  
✅ Mobile responsive  
✅ Category navigation  
✅ Floating buttons  

## Updating Menus

To update a menu:
1. Create new snapshot in CRM `/versions`
2. Download new HTML
3. Delete old menu in WordPress admin (optional)
4. Upload new HTML
5. Update shortcode if menu ID changed

## Comparison: JSON vs Standalone HTML

| Feature | JSON Method | Standalone HTML |
|---------|-------------|-----------------|
| Setup | Medium | Easy |
| Appearance | Custom templates | Exact standalone |
| Cart functionality | Needs plugin update | Built-in ✅ |
| Share functionality | Needs plugin update | Built-in ✅ |
| Updates | Template changes | Re-upload HTML |
| Maintenance | Higher | Lower |

## Recommendation

**Use Standalone HTML** if you want:
- Menu to look identical to standalone version
- All features working immediately
- Easy maintenance
- Quick deployment

**Use JSON** if you need:
- Custom WordPress theme integration
- Special layout modifications
- Direct database integration

## Technical Details

### How it works:
1. HTML file is stored in WordPress options table
2. When shortcode is rendered, HTML is extracted
3. Styles and scripts are embedded directly in page
4. Full functionality preserved from standalone version

### Performance:
- HTML is cached in WordPress database
- No external file dependencies
- All assets (CSS/JS) embedded
- Fast page load

## Troubleshooting

**Q: Menu doesn't display**  
A: Check that shortcode ID matches uploaded menu ID

**Q: Cart doesn't work**  
A: Make sure you uploaded the complete HTML file from `/versions` export

**Q: Styles conflict with theme**  
A: Standalone HTML uses scoped styles - minimal conflict

**Q: How to have multiple locations?**  
A: Upload multiple HTML files, each gets unique ID. Use menu list or separate pages.

## Support

For issues or questions, contact CRM admin or check the main plugin README.md
