# Quick Reference Card - Samanta Menu Plugin

## 🚀 Quick Start (Standalone HTML - Recommended)

```
1. CRM: /versions → Select Location → Create Snapshot → Download HTML
2. WordPress: Menu Lokali → Standalone HTML → Upload
3. Copy shortcode: [samanta_standalone id="menu_xxx"]
4. Paste in page → Publish
```

---

## 📝 All Shortcodes

### Standalone HTML (v2.0+)

| Shortcode | Purpose | Example |
|-----------|---------|---------|
| `[samanta_standalone id="xxx"]` | Show specific menu | `[samanta_standalone id="menu_abc123"]` |
| `[samanta_standalone]` | Show menu list | Auto-generates links |

### JSON Menus (v1.0+)

| Shortcode | Purpose | Example |
|-----------|---------|---------|
| `[samanta_menu location="X"]` | Show specific location | `[samanta_menu location="1"]` |
| `[samanta_menu]` | Dynamic by URL | Use with `?location=1` |
| `[samanta_locations]` | Show location picker | Links to menus |

---

## 🎯 Common Use Cases

### Single Location Website
```
Page: /menu
Shortcode: [samanta_standalone id="menu_abc123"]
```

### Multiple Locations
```
Page: /menu
Shortcode: [samanta_standalone]
Result: Shows clickable list of all locations
```

### Separate Page Per Location
```
Page: /menu-kosciuszki
Shortcode: [samanta_standalone id="menu_abc123"]

Page: /menu-centrum  
Shortcode: [samanta_standalone id="menu_xyz456"]
```

### Dynamic Menu (One Page, Multiple Locations)
```
Page: /menu
Shortcode: [samanta_standalone]

URLs:
- yoursite.com/menu?menu_id=menu_abc123
- yoursite.com/menu?menu_id=menu_xyz456
```

---

## 🎨 Features Available

### Standalone HTML
✅ Cart system  
✅ Share (WhatsApp, SMS, Email, Messenger)  
✅ Language toggle (PL/EN)  
✅ Image lightbox  
✅ Category navigation  
✅ Mobile responsive  
✅ Smooth animations  

### JSON Menus
✅ Language toggle (PL/EN)  
✅ Category navigation  
✅ Mobile responsive  
✅ Smooth animations  
❌ Cart (requires custom development)  
❌ Share (requires custom development)  

---

## 📂 File Locations

```
/wp-content/plugins/samanta-menu/
├── samanta-menu.php          # Main plugin file
├── admin/
│   └── admin-page.php        # Admin interface
├── assets/
│   ├── admin.css             # Admin styles
│   ├── admin.js              # Admin scripts
│   ├── menu.css              # Frontend styles (JSON)
│   └── menu.js               # Frontend scripts (JSON)
├── templates/
│   ├── menu-display.php      # JSON menu template
│   └── locations.php         # Location picker template
└── README.md                 # Documentation
```

---

## 🔧 Admin Locations

| Task | Navigation |
|------|------------|
| Upload menu | WP Admin → Menu Lokali |
| View uploaded menus | Menu Lokali → (tabs) |
| Get shortcode | Menu Lokali → Copy button |
| Delete menu | Menu Lokali → Usuń button |

---

## ⚡ Updating Menus

### Standalone HTML
```
1. Create new snapshot in CRM
2. Download new HTML
3. Upload to WordPress (Menu Lokali)
4. Optional: Delete old version
5. Update shortcode if ID changed
```

### JSON
```
1. Export new JSON from CRM  
2. Upload in Menu Lokali → JSON Menus
3. Overwrites existing (same location ID)
```

---

## 🐛 Quick Troubleshooting

| Problem | Solution |
|---------|----------|
| Menu not showing | Check shortcode ID is correct |
| No cart/share | Use Standalone HTML, not JSON |
| Styles conflict | Standalone HTML uses scoped styles |
| Shortcode shows as text | Make sure plugin is activated |
| Old menu showing | Clear WordPress cache |

---

## 📞 Getting Help

1. Check README.md for detailed info
2. See STANDALONE_USAGE.md for standalone guide
3. Review INSTALLATION.md for setup help
4. Check CHANGELOG.md for version history
5. Contact CRM administrator

---

## 💡 Pro Tips

✅ **Use Standalone HTML** - easier and better  
✅ **One menu ID per page** - cleaner URLs  
✅ **Test before going live** - use draft pages  
✅ **Keep CRM snapshots** - backup your menus  
✅ **Clear cache** after updates - see changes immediately  

---

## 📊 Comparison

|  | JSON | Standalone HTML |
|--|------|-----------------|
| Setup | ⭐⭐⭐ | ⭐⭐⭐⭐⭐ |
| Features | ⭐⭐⭐ | ⭐⭐⭐⭐⭐ |
| Maintenance | ⭐⭐⭐ | ⭐⭐⭐⭐⭐ |
| Visual match | ⭐⭐⭐ | ⭐⭐⭐⭐⭐ |
| **Recommended** | For custom needs | **For most users** ✅ |

---

_Quick Reference v2.0 - Updated Dec 2025_
