# Installation & Upgrade Guide

## For New Installations

### Step 1: Install Plugin
1. Upload `samanta-menu` folder to `/wp-content/plugins/`
2. Go to WordPress Admin → Plugins
3. Activate "Samanta Menu Display"

### Step 2: Upload Menu
1. Go to **Menu Lokali** in WordPress admin
2. Choose one of two methods:
   - **Recommended**: Click "Standalone HTML" tab → Upload HTML file from `/versions`
   - **Alternative**: Use "JSON Menus" tab → Upload JSON export

### Step 3: Add to Page
1. Create/Edit a WordPress page
2. Add shortcode (get it from Menu Lokali page)
3. Publish!

---

## Upgrading from v1.0 to v2.0

### What's New in v2.0
✅ Standalone HTML support  
✅ 100% visual match with standalone version  
✅ Built-in cart & share functionality  
✅ Easier maintenance  

### Upgrade Steps

#### Option A: In-place Upgrade (Keep existing menus)
1. Deactivate old plugin (don't delete)
2. Replace plugin files with new version
3. Reactivate plugin
4. Existing JSON menus continue to work
5. New "Standalone HTML" tab available

#### Option B: Fresh Install
1. Deactivate and delete old plugin
2. Install new version
3. Re-upload menus (JSON or HTML)

### Migration: JSON → Standalone HTML

If you want to switch from JSON to Standalone HTML:

1. **Export HTML from CRM**
   - Go to `/samanta_crm/versions`
   - Select same location as current JSON menu
   - Create snapshot
   - Download HTML file

2. **Upload to WordPress**
   - Menu Lokali → Standalone HTML tab
   - Upload the HTML file
   - Copy new shortcode

3. **Update Pages**
   - Find pages using old shortcode: `[samanta_menu location="X"]`
   - Replace with new: `[samanta_standalone id="menu_xxx"]`
   
4. **Test**
   - Verify menu displays correctly
   - Test cart functionality
   - Test share functionality

5. **Cleanup (Optional)**
   - Delete old JSON menu in "JSON Menus" tab

### No Downtime Approach

1. Upload new HTML (new shortcode generated)
2. Create duplicate page with new shortcode
3. Test thoroughly
4. Update original page when ready
5. Delete test page

---

## Troubleshooting Upgrade

### Plugin doesn't activate
- Check PHP version (minimum 7.4)
- Check WordPress version (minimum 5.0)
- Check for plugin conflicts

### Old menus disappeared
- They're still in database
- Go to "JSON Menus" tab to see them
- Option is `samanta_menu_data`

### Shortcodes not working
- Clear WordPress cache
- Clear browser cache
- Re-save permalinks (Settings → Permalinks → Save)

### Features not showing
- Make sure using v2.0 files
- Check plugin version in Plugins page (should show 2.0.0)
- Deactivate and reactivate

---

## Rollback to v1.0

If you need to revert:

1. Deactivate v2.0
2. Delete v2.0 plugin folder
3. Upload v1.0 plugin folder
4. Activate v1.0
5. Your JSON menus will still work
6. Standalone HTML menus will not be accessible

**Note**: Standalone HTML data stored in `wp_options` as `samanta_menu_standalone_html` - it won't be lost, just inaccessible until you upgrade again.

---

## Database Cleanup

If you want to remove all plugin data:

### Via PHP/phpMyAdmin
```sql
DELETE FROM wp_options WHERE option_name = 'samanta_menu_data';
DELETE FROM wp_options WHERE option_name = 'samanta_menu_standalone_html';
```

### Via WordPress
When deleting plugin, choose "Delete plugin data" option (if available)

---

## Support

- Check documentation: README.md, STANDALONE_USAGE.md
- Review update summary: UPDATE_SUMMARY.md
- Contact CRM administrator for technical support
