# Changelog

## Version 2.0.0 (2025-12-13)

### ⭐ Major New Features

#### Standalone HTML Upload
- **Upload complete HTML files** directly from `/versions` export
- **100% visual match** with standalone version - pixel perfect!
- **Built-in cart functionality** - add items, view cart, share selections
- **Built-in share functionality** - WhatsApp, SMS, Email, Messenger
- **Self-contained** - all CSS and JavaScript embedded
- **Zero configuration** - works immediately after upload

#### New Shortcode
- `[samanta_standalone id="menu_xxx"]` - Display specific standalone menu
- `[samanta_standalone]` - Display list of all standalone menus
- Supports `?menu_id=xxx` URL parameter for dynamic loading

### 🎨 UI Improvements

#### Admin Interface
- **Tabbed interface**: Separate "JSON Menus" and "Standalone HTML" sections
- Clean upload area for HTML files
- Table view of uploaded standalone menus
- One-click shortcode copying
- File name and upload date tracking

### 🔧 Technical Improvements

#### Core Plugin
- New AJAX handlers: `samanta_upload_standalone_html`, `samanta_delete_standalone_html`
- New WordPress option: `samanta_menu_standalone_html`
- Improved storage structure with metadata
- Smart HTML extraction and embedding
- Iframe fallback for compatibility

#### JavaScript
- Tab switching functionality
- Separate message areas for JSON and HTML uploads
- Enhanced error handling
- Upload progress indication

### 📚 Documentation

- **STANDALONE_USAGE.md** - Complete usage guide
- **UPDATE_SUMMARY.md** - Technical change summary  
- **INSTALLATION.md** - Installation and upgrade guide
- **CHANGELOG.md** - This file
- Updated main README.md with new feature highlights

### 🔄 Backwards Compatibility

- ✅ **100% compatible** with existing JSON menus
- ✅ Existing shortcodes continue to work
- ✅ No breaking changes
- ✅ Smooth upgrade path from v1.0

---

## Version 1.0.0 (Initial Release)

### Features

#### JSON Menu Upload
- Upload menu JSON files from CRM system
- Automatic parsing and validation
- Store multiple location menus

#### Display Features
- Language toggle (PL/EN)
- Category navigation
- Item display with images
- Price variants
- Responsive design
- AOS animations

#### Shortcodes
- `[samanta_menu location="X"]` - Display specific location menu
- `[samanta_menu]` - Display menu based on URL parameter
- `[samanta_locations]` - Display location selector

#### Admin Interface
- Menu upload form
- Menu management table
- Delete functionality
- Shortcode generation
- Usage instructions

#### Frontend Features
- Sticky category navigation
- Language switching
- Smooth scrolling
- Mobile responsive
- Custom styling (menu.css)
- Interactive JavaScript (menu.js)

### Technical Details
- WordPress 5.0+ compatible
- PHP 7.4+ compatible
- Bootstrap 5.3.3
- AOS (Animate On Scroll)
- jQuery integration

---

## Planned Features (Future Versions)

### Version 2.1.0 (Planned)
- Bulk HTML upload
- Menu preview in admin
- Template selector for JSON menus
- Export functionality
- Menu scheduling (auto-publish)

### Version 2.2.0 (Planned)
- Multi-language admin interface
- Custom CSS editor
- Menu analytics
- A/B testing support
- SEO optimization

### Version 3.0.0 (Planned)
- API integration with CRM
- Auto-sync functionality
- Real-time updates
- Menu builder in WordPress
- Advanced customization options

---

## Support & Feedback

For bug reports, feature requests, or technical support:
- Contact CRM administrator
- Review documentation files
- Check WordPress plugin support forum
