<?php
// Simulate the update process to debug
session_start();

// Simulate POST data like from edit form
$_POST = [
    'name' => 'Test User Type',
    'description' => 'Test description',
    'color' => '#ff0000',
    'is_active' => '1',
    'permissions' => [
        'users.view' => '1',
        'users.create' => '1',
        'dashboard.view' => '1'
    ]
];

echo "<h2>Update Process Debug</h2>";

echo "<h3>1. Raw POST data:</h3>";
echo "<pre>";
print_r($_POST['permissions']);
echo "</pre>";

// Simulate processPermissions method
function processPermissions($permissions)
{
    $processed = [];
    
    if (is_array($permissions)) {
        foreach ($permissions as $permission => $value) {
            // Store permissions as flat key-value pairs
            $processed[$permission] = true;
        }
    }
    
    return $processed;
}

$processedPermissions = processPermissions($_POST['permissions'] ?? []);

echo "<h3>2. Processed permissions:</h3>";
echo "<pre>";
print_r($processedPermissions);
echo "</pre>";

echo "<h3>3. JSON that would be stored:</h3>";
echo "<pre>";
echo json_encode($processedPermissions, JSON_PRETTY_PRINT);
echo "</pre>";

echo "<h3>4. Count:</h3>";
echo count($processedPermissions);

// Now let's check what the actual UserType model would do
require_once 'bootstrap/db.php';
require_once 'app/Models/UserType.php';

$userType = new UserType();

echo "<h3>5. Current UserType #6 data:</h3>";
$type6 = $userType->findById(6);
if ($type6) {
    echo "<pre>";
    print_r($type6);
    echo "</pre>";
}
?>
