<?php
/**
 * Setup menu categories for restaurant menu system
 */

require_once __DIR__ . '/bootstrap/db.php';

try {
    echo "Setting up menu categories...\n\n";
    
    $categories = [
        'Kawy',
        'Herbaty',
        'Matcha',
        'Kawy mrożone',
        'Soki',
        'Soki ze świeżych owoców',
        'Smoothies',
        'Gorące czekolady',
        'Shakes',
        'Napoje zimne',
        'Dodatki',
        'Desery',
        'Lody',
        'Dodatki lody',
        'Kanapki',
        'Śniadania',
        'Tosty',
        'Naleśniki',
        'Gofry',
        'Alkohole',
        'Alkohole na ciepło',
        'Piwa',
        'Drinki',
        'Nalewki',
        'Zimowe Specjały',
        'Napoje i Lemoniady',
        'Menu dla dzieci',
        'Ciastka bezglutenowe'
    ];
    
    $stmt = $pdo->prepare("INSERT INTO categories (name) VALUES (?) ON DUPLICATE KEY UPDATE name = VALUES(name)");
    
    $count = 0;
    foreach ($categories as $category) {
        $stmt->execute([$category]);
        echo "✓ {$category}\n";
        $count++;
    }
    
    echo "\n✅ Successfully created/updated {$count} menu categories!\n";
    
} catch (PDOException $e) {
    echo "❌ Error: " . $e->getMessage() . "\n";
    exit(1);
}
