<?php
echo "<h2>Redirect Debug</h2>";

echo "<h3>Server Variables:</h3>";
echo "<p><strong>REQUEST_URI:</strong> " . ($_SERVER['REQUEST_URI'] ?? 'Not set') . "</p>";
echo "<p><strong>SCRIPT_NAME:</strong> " . ($_SERVER['SCRIPT_NAME'] ?? 'Not set') . "</p>";
echo "<p><strong>HTTP_HOST:</strong> " . ($_SERVER['HTTP_HOST'] ?? 'Not set') . "</p>";
echo "<p><strong>REQUEST_METHOD:</strong> " . ($_SERVER['REQUEST_METHOD'] ?? 'Not set') . "</p>";

echo "<h3>Current File Location:</h3>";
echo "<p><strong>__FILE__:</strong> " . __FILE__ . "</p>";
echo "<p><strong>Document Root:</strong> " . ($_SERVER['DOCUMENT_ROOT'] ?? 'Not set') . "</p>";

session_start();
echo "<h3>Session Check:</h3>";
if (isset($_SESSION['user_id'])) {
    echo "<p style='color: green;'>✅ Logged in as: " . ($_SESSION['user_name'] ?? 'Unknown') . " (ID: " . $_SESSION['user_id'] . ")</p>";
} else {
    echo "<p style='color: red;'>❌ Not logged in</p>";
}

echo "<h3>URL Tests:</h3>";
echo "<p><a href='/samanta_crm/' target='_blank'>Root (/samanta_crm/)</a></p>";
echo "<p><a href='/samanta_crm/login' target='_blank'>Login</a></p>";
echo "<p><a href='/samanta_crm/dashboard' target='_blank'>Dashboard</a></p>";
echo "<p><a href='/samanta_crm/public/' target='_blank'>Public Root</a></p>";
echo "<p><a href='/samanta_crm/public/index.php' target='_blank'>Direct Index</a></p>";

echo "<h3>Manual Router Test:</h3>";
try {
    require_once 'bootstrap/router.php';
    
    $router = new Router();
    $router->get('/dashboard', 'UserController@dashboard');
    
    echo "<p>Testing dispatch for '/samanta_crm/dashboard'...</p>";
    ob_start();
    $router->dispatch('/samanta_crm/dashboard', 'GET');
    $output = ob_get_clean();
    
    if (empty($output)) {
        echo "<p style='color: orange;'>⚠ No output from router</p>";
    } else {
        echo "<p style='color: green;'>✅ Router produced output</p>";
    }
} catch (Exception $e) {
    echo "<p style='color: red;'>❌ Router error: " . $e->getMessage() . "</p>";
}
?>
