<?php
/**
 * Add Common Translations Script
 * Adds all the standard common translation keys
 */

require_once '../bootstrap/env.php';
require_once '../bootstrap/db.php';
require_once '../app/helpers/TranslationHelper.php';

session_start();
if (!isset($_SESSION['language'])) {
    $_SESSION['language'] = 'en';
}

echo "<h2>Adding Common Translations</h2>";

$helper = new TranslationHelper();

// Common translations for English
$commonTranslations = [
    'common.actions' => 'Actions',
    'common.active' => 'Active',
    'common.all' => 'All',
    'common.cancel' => 'Cancel',
    'common.confirm_password' => 'Confirm Password',
    'common.create' => 'Create',
    'common.created_at' => 'Created At',
    'common.delete' => 'Delete',
    'common.edit' => 'Edit',
    'common.email' => 'Email',
    'common.filter' => 'Filter',
    'common.inactive' => 'Inactive',
    'common.name' => 'Name',
    'common.no' => 'No',
    'common.password' => 'Password',
    'common.save' => 'Save',
    'common.search' => 'Search',
    'common.status' => 'Status',
    'common.submit' => 'Submit',
    'common.type' => 'Type',
    'common.update' => 'Update',
    'common.updated_at' => 'Updated At',
    'common.yes' => 'Yes'
];

echo "<p>Adding common translation keys...</p>";

$result = $helper->addEnglishTranslations($commonTranslations, 'common');

$totalSuccess = 0;
$totalErrors = 0;

foreach ($result as $key => $keyResult) {
    foreach ($keyResult['success'] as $success) {
        echo "<p style='color: green;'>✓ $success</p>";
        $totalSuccess++;
    }
    
    foreach ($keyResult['errors'] as $error) {
        echo "<p style='color: red;'>✗ $error</p>";
        $totalErrors++;
    }
}

echo "<hr>";
echo "<h3>Summary:</h3>";
echo "<p><strong>✅ Added: $totalSuccess translations</strong></p>";
if ($totalErrors > 0) {
    echo "<p><strong>❌ Errors: $totalErrors</strong></p>";
}

echo "<p>All common translations have been added to the database!</p>";
echo "<p><a href='/samanta_crm/languages'>Manage Translations</a></p>";
?>
