# Instrukcja Importu Zamówień Regularnych

## Wymagane Pliki

System wymaga **dwóch plików CSV** do zaimportowania zamówień regularnych:

### 1. Plik Zamówień (orders.csv)
Zawiera podstawowe informacje o zamówieniach.

**Wymagane kolumny:**
- `order_id` - unikalny ID zamówienia (np. Parent Entry ID z systemu źródłowego)
- `customer_name` - imię i nazwisko klienta
- `customer_phone` - numer telefonu (system automatycznie dopasuje istniejących klientów)
- `customer_email` - adres email (opcjonalny)
- `customer_address` - adres klienta (opcjonalny)
- `order_date` - data zamówienia (format: YYYY-MM-DD)
- `order_time` - godzina zamówienia (format: HH:MM:SS)
- `delivery_date` - data dostawy/odbioru (format: YYYY-MM-DD)
- `order_type` - typ zamówienia: `daily`, `cake`, `inhouse`
- `status` - status: `pending`, `completed`, `cancelled`
- `notes` - uwagi do zamówienia (opcjonalny)

**Przykład:**
```csv
order_id,customer_name,customer_phone,customer_email,customer_address,order_date,order_time,delivery_date,order_type,status,notes
486779,Jan Kowalski,123456789,jan@example.com,ul. Testowa 1,2025-11-29,07:45:00,2025-11-30,daily,pending,Uwagi
```

### 2. Plik Produktów (items.csv)
Zawiera produkty w każdym zamówieniu. Ten plik masz już przygotowany!

**Wymagane kolumny:**
- `Parent Entry ID` - ID zamówienia (musi odpowiadać `order_id` z pliku zamówień)
- `Nazwa` - nazwa produktu
- `Ilość` - ilość produktu
- `Id` - ID produktu w systemie

**Przykład (już masz taki plik):**
```csv
"Ilość","Nazwa","Cena","Kategoria","Opis","Id","Utworzono przez (ID użytkownika)","ID pozycji","Data pozycji","Data aktualizacji","Źródłowy adres URL","ID transakcji","Wielkość płatności","Termin płatności","Status płatności","Id wpisu","Agent użytkownika","Adres IP użytkownika","Approval Status","","Parent Entry ID","Parent Entry Form ID","Child Form Field ID"
"15","Deser Panna Cotta","","Desery","","1362","170","486778","2025-11-29 07:49:58","2025-11-29 06:49:58","...","...","...","...","...","...","...","...","3","","486779","7","5"
```

## Jak Połączyć Pliki

System automatycznie połączy zamówienia z produktami na podstawie:
- `order_id` w pliku zamówień = `Parent Entry ID` w pliku produktów

**Przykład:**
- Zamówienie: `order_id = 486779`
- Produkty: wszystkie wiersze gdzie `Parent Entry ID = 486779`

## Proces Importu

1. **Przygotuj plik zamówień** - musisz utworzyć CSV z kolumnami jak powyżej
2. **Użyj istniejącego pliku produktów** - już go masz (systemowe-produkty-zamówienie-2025-11-29.csv)
3. **Wejdź na stronę migracji** - `/samanta_crm/migration`
4. **Wybierz oba pliki** w sekcji "Import Zamówień Regularnych"
5. **Kliknij "Importuj"**

## Co Robi System

1. **Wczytuje plik produktów** - ładuje wszystkie produkty do pamięci, grupując po `Parent Entry ID`
2. **Przetwarza zamówienia** - dla każdego zamówienia:
   - Tworzy lub znajduje klienta (po numerze telefonu)
   - Tworzy zamówienie
   - Dodaje produkty z pliku produktów (gdzie Parent Entry ID = order_id)
   - Pobiera ceny produktów z bazy danych
3. **Pomija duplikaty** - jeśli zamówienie z danym `order_id` już istnieje
4. **Raportuje błędy** - pokazuje szczegółowy raport

## Jak Przygotować Plik Zamówień

Jeśli Twoje zamówienia są w systemie Gravity Forms, musisz wyeksportować dane z formularza zawierającego:
- Parent Entry ID (ID wpisu głównego)
- Dane klienta (imię, telefon, email, adres)
- Daty (zamówienia, dostawy)
- Typ i status

Następnie przekształć je do formatu CSV z kolumnami jak w szablonie `TEMPLATE_orders.csv`.

## Uwagi Techniczne

- System przetwarza dane w partiach (batch) - możesz wybrać 25, 50, 100 lub 200 rekordów na raz
- Duplikaty są wykrywane po `order_id` (Old Order ID)
- Klienci są dopasowywani po numerze telefonu
- Ceny produktów są pobierane z tabeli `products` na podstawie `Id`
- Jeśli produkt nie istnieje w bazie, cena = 0.00
